/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Pending;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;
import org.jbehave.core.steps.context.StepsContext;

public class StepCandidate {
    private final String patternAsString;
    private final Integer priority;
    private final StepType stepType;
    private final Method method;
    private final Class<?> stepsType;
    private final InjectableStepsFactory stepsFactory;
    private final Keywords keywords;
    private final StepMatcher stepMatcher;
    private final StepCreator stepCreator;
    private String[] composedSteps;
    private StepMonitor stepMonitor = new SilentStepMonitor();

    public StepCandidate(String patternAsString, int priority, StepType stepType, Method method, Class<?> stepsType, InjectableStepsFactory stepsFactory, StepsContext stepsContext, Keywords keywords, StepPatternParser stepPatternParser, ParameterConverters parameterConverters, ParameterControls parameterControls) {
        this.patternAsString = patternAsString;
        this.priority = priority;
        this.stepType = stepType;
        this.method = method;
        this.stepsType = stepsType;
        this.stepsFactory = stepsFactory;
        this.keywords = keywords;
        this.stepMatcher = stepPatternParser.parseStep(stepType, patternAsString);
        this.stepCreator = new StepCreator(stepsType, stepsFactory, stepsContext, parameterConverters, parameterControls, this.stepMatcher, this.stepMonitor);
    }

    public Method getMethod() {
        return this.method;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getPatternAsString() {
        return this.patternAsString;
    }

    public Object getStepsInstance() {
        return this.stepsFactory.createInstanceOfType(this.stepsType);
    }

    public Class<?> getStepsType() {
        return this.stepsType;
    }

    public StepType getStepType() {
        return this.stepType;
    }

    public String getStartingWord() {
        return this.keywords.startingWordFor(this.stepType);
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        this.stepCreator.useStepMonitor(stepMonitor);
    }

    public void doDryRun(boolean dryRun) {
        this.stepCreator.doDryRun(dryRun);
    }

    public void useParanamer(Paranamer paranamer) {
        this.stepCreator.useParanamer(paranamer);
    }

    public void composedOf(String[] steps) {
        this.composedSteps = steps;
    }

    public boolean isComposite() {
        return this.composedSteps != null && this.composedSteps.length > 0;
    }

    public String[] composedSteps() {
        return this.composedSteps;
    }

    public boolean ignore(String stepAsString) {
        try {
            String ignoreWord = this.keywords.startingWordFor(StepType.IGNORABLE);
            return this.isIgnoredStep(stepAsString, ignoreWord);
        }
        catch (Keywords.StartingWordNotFound e) {
            return false;
        }
    }

    public boolean comment(String stepAsString) {
        try {
            String ignoreWord = this.keywords.startingWordFor(StepType.IGNORABLE);
            return this.keywords.stepStartsWithWord(stepAsString, ignoreWord) && !this.isIgnoredStep(stepAsString, ignoreWord);
        }
        catch (Keywords.StartingWordNotFound e) {
            return false;
        }
    }

    private boolean isIgnoredStep(String stepAsString, String ignoreWord) {
        for (Map.Entry<StepType, String> stepStartingWord : this.keywords.startingWordsByType().entrySet()) {
            if (stepStartingWord.getKey() == StepType.IGNORABLE || !this.keywords.stepStartsWithWords(stepAsString, ignoreWord, stepStartingWord.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isPending() {
        return this.method.isAnnotationPresent(Pending.class);
    }

    public boolean matches(String stepAsString) {
        return this.matches(stepAsString, null);
    }

    public boolean matches(String step, String previousNonAndStep) {
        try {
            boolean matchesType = true;
            if (this.isAndStep(step)) {
                matchesType = previousNonAndStep == null ? false : this.keywords.startingWordFor(this.stepType).equals(this.findStartingWord(previousNonAndStep));
            }
            this.stepMonitor.stepMatchesType(step, previousNonAndStep, matchesType, this.stepType, this.method, this.stepsType);
            boolean matchesPattern = this.stepMatcher.matches(this.stripStartingWord(step));
            this.stepMonitor.stepMatchesPattern(step, matchesPattern, this.stepMatcher.pattern(), this.method, this.stepsType);
            return matchesType && matchesPattern;
        }
        catch (Keywords.StartingWordNotFound e) {
            return false;
        }
    }

    public Step createMatchedStep(String stepAsString, Map<String, String> namedParameters) {
        return this.stepCreator.createParametrisedStep(this.method, stepAsString, this.stripStartingWord(stepAsString), namedParameters);
    }

    public Step createMatchedStepUponOutcome(String stepAsString, Map<String, String> namedParameters, AfterScenario.Outcome outcome) {
        return this.stepCreator.createParametrisedStepUponOutcome(this.method, stepAsString, this.stripStartingWord(stepAsString), namedParameters, outcome);
    }

    public void addComposedSteps(List<Step> steps, String stepAsString, Map<String, String> namedParameters, List<StepCandidate> allCandidates) {
        this.addComposedStepsRecursively(steps, stepAsString, namedParameters, allCandidates, this.composedSteps);
    }

    private void addComposedStepsRecursively(List<Step> steps, String stepAsString, Map<String, String> namedParameters, List<StepCandidate> allCandidates, String[] composedSteps) {
        Map<String, String> matchedParameters = this.stepCreator.matchedParameters(this.method, stepAsString, this.stripStartingWord(stepAsString), namedParameters);
        matchedParameters.putAll(namedParameters);
        for (String composedStep : composedSteps) {
            this.addComposedStep(steps, composedStep, matchedParameters, allCandidates);
        }
    }

    private void addComposedStep(List<Step> steps, String composedStep, Map<String, String> matchedParameters, List<StepCandidate> allCandidates) {
        StepCandidate candidate = this.findComposedCandidate(composedStep, allCandidates);
        if (candidate != null) {
            steps.add(candidate.createMatchedStep(composedStep, matchedParameters));
            if (candidate.isComposite()) {
                this.addComposedStepsRecursively(steps, composedStep, matchedParameters, allCandidates, candidate.composedSteps());
            }
        } else {
            steps.add(StepCreator.createPendingStep(composedStep, null));
        }
    }

    private StepCandidate findComposedCandidate(String composedStep, List<StepCandidate> allCandidates) {
        for (StepCandidate candidate : allCandidates) {
            if (!StringUtils.startsWith((CharSequence)composedStep, (CharSequence)candidate.getStartingWord()) || !StringUtils.endsWith((CharSequence)composedStep, (CharSequence)candidate.getPatternAsString()) && !candidate.matches(composedStep)) continue;
            return candidate;
        }
        return null;
    }

    public boolean isAndStep(String stepAsString) {
        return this.keywords.isAndStep(stepAsString);
    }

    public boolean isIgnorableStep(String stepAsString) {
        return this.keywords.isIgnorableStep(stepAsString);
    }

    private String findStartingWord(String stepAsString) {
        return this.keywords.startingWord(stepAsString, this.stepType);
    }

    private String stripStartingWord(String stepAsString) {
        return this.keywords.stepWithoutStartingWord(stepAsString, this.stepType);
    }

    public String toString() {
        return (Object)((Object)this.stepType) + " " + this.patternAsString;
    }
}

