/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepFinder;
import org.jbehave.core.steps.StepMonitor;

public class MarkUnmatchedStepsAsPending
implements StepCollector {
    private final StepFinder stepFinder;
    private final Keywords keywords;

    public MarkUnmatchedStepsAsPending() {
        this(new StepFinder());
    }

    public MarkUnmatchedStepsAsPending(StepFinder stepFinder) {
        this(stepFinder, new LocalizedKeywords());
    }

    public MarkUnmatchedStepsAsPending(Keywords keywords) {
        this(new StepFinder(), keywords);
    }

    public MarkUnmatchedStepsAsPending(StepFinder stepFinder, Keywords keywords) {
        this.stepFinder = stepFinder;
        this.keywords = keywords;
    }

    @Override
    public List<Step> collectBeforeOrAfterStoriesSteps(List<CandidateSteps> candidateSteps, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            steps.addAll(this.createSteps(candidates.listBeforeOrAfterStories(), stage));
        }
        return steps;
    }

    @Override
    public List<Step> collectBeforeOrAfterStorySteps(List<CandidateSteps> candidateSteps, Story story, StepCollector.Stage stage, boolean givenStory) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            steps.addAll(this.createSteps(candidates.listBeforeOrAfterStory(givenStory), story.getMeta(), stage));
        }
        return steps;
    }

    @Override
    public List<Step> collectBeforeOrAfterScenarioSteps(List<CandidateSteps> candidateSteps, Meta storyAndScenarioMeta, StepCollector.Stage stage, ScenarioType type) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            List<BeforeOrAfterStep> beforeOrAfterScenarioSteps = candidates.listBeforeOrAfterScenario(type);
            if (stage == StepCollector.Stage.BEFORE) {
                steps.addAll(this.createSteps(beforeOrAfterScenarioSteps, storyAndScenarioMeta, stage));
                continue;
            }
            steps.addAll(0, this.createStepsUponOutcome(beforeOrAfterScenarioSteps, storyAndScenarioMeta, stage));
        }
        return steps;
    }

    @Override
    public List<Step> collectLifecycleSteps(List<CandidateSteps> candidateSteps, Lifecycle lifecycle, Meta storyAndScenarioMeta, StepCollector.Stage stage) {
        return this.collectLifecycleSteps(candidateSteps, lifecycle, storyAndScenarioMeta, stage, Scope.SCENARIO);
    }

    @Override
    public List<Step> collectLifecycleSteps(List<CandidateSteps> candidateSteps, Lifecycle lifecycle, Meta storyAndScenarioMeta, StepCollector.Stage stage, Scope scope) {
        ArrayList<Step> steps = new ArrayList<Step>();
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        if (stage == StepCollector.Stage.BEFORE) {
            this.addMatchedSteps(lifecycle.getBeforeSteps(scope), steps, namedParameters, candidateSteps);
        } else {
            this.addMatchedSteps(lifecycle.getAfterSteps(scope, AfterScenario.Outcome.ANY, storyAndScenarioMeta), steps, namedParameters, candidateSteps, AfterScenario.Outcome.ANY);
            this.addMatchedSteps(lifecycle.getAfterSteps(scope, AfterScenario.Outcome.SUCCESS, storyAndScenarioMeta), steps, namedParameters, candidateSteps, AfterScenario.Outcome.SUCCESS);
            this.addMatchedSteps(lifecycle.getAfterSteps(scope, AfterScenario.Outcome.FAILURE, storyAndScenarioMeta), steps, namedParameters, candidateSteps, AfterScenario.Outcome.FAILURE);
        }
        return steps;
    }

    @Override
    public List<Step> collectScenarioSteps(List<CandidateSteps> candidateSteps, Scenario scenario, Map<String, String> parameters) {
        return this.collectScenarioSteps(candidateSteps, scenario, parameters, new NullStepMonitor());
    }

    @Override
    public List<Step> collectScenarioSteps(List<CandidateSteps> candidateSteps, Scenario scenario, Map<String, String> parameters, StepMonitor stepMonitor) {
        ArrayList<Step> steps = new ArrayList<Step>();
        this.addMatchedSteps(scenario.getSteps(), steps, parameters, candidateSteps, stepMonitor);
        return steps;
    }

    private List<Step> createSteps(List<BeforeOrAfterStep> beforeOrAfter, StepCollector.Stage stage) {
        return this.createSteps(beforeOrAfter, null, stage);
    }

    private List<Step> createSteps(List<BeforeOrAfterStep> beforeOrAfter, Meta meta, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (BeforeOrAfterStep step : beforeOrAfter) {
            if (stage != step.getStage()) continue;
            steps.add(meta == null ? step.createStep() : step.createStepWith(meta));
        }
        return steps;
    }

    private List<Step> createStepsUponOutcome(List<BeforeOrAfterStep> beforeOrAfter, Meta storyAndScenarioMeta, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (BeforeOrAfterStep step : beforeOrAfter) {
            if (stage != step.getStage()) continue;
            steps.add(step.createStepUponOutcome(storyAndScenarioMeta));
        }
        return steps;
    }

    private void addMatchedSteps(List<String> stepsAsString, List<Step> steps, Map<String, String> namedParameters, List<CandidateSteps> candidateSteps) {
        this.addMatchedSteps(stepsAsString, steps, namedParameters, candidateSteps, (AfterScenario.Outcome)null);
    }

    private void addMatchedSteps(List<String> stepsAsString, List<Step> steps, Map<String, String> namedParameters, List<CandidateSteps> candidateSteps, AfterScenario.Outcome outcome) {
        this.addMatchedSteps(stepsAsString, steps, namedParameters, candidateSteps, outcome, new NullStepMonitor());
    }

    private void addMatchedSteps(List<String> stepsAsString, List<Step> steps, Map<String, String> namedParameters, List<CandidateSteps> candidateSteps, StepMonitor stepMonitor) {
        this.addMatchedSteps(stepsAsString, steps, namedParameters, candidateSteps, null, stepMonitor);
    }

    private void addMatchedSteps(List<String> stepsAsString, List<Step> steps, Map<String, String> namedParameters, List<CandidateSteps> candidateSteps, AfterScenario.Outcome outcome, StepMonitor stepMonitor) {
        List<StepCandidate> allCandidates = this.stepFinder.collectCandidates(candidateSteps);
        String previousNonAndStep = null;
        for (String stepAsString : stepsAsString) {
            Step step = StepCreator.createPendingStep(stepAsString, previousNonAndStep);
            ArrayList<Step> composedSteps = new ArrayList<Step>();
            List<StepCandidate> prioritisedCandidates = this.stepFinder.prioritise(stepAsString, allCandidates);
            for (StepCandidate candidate : prioritisedCandidates) {
                candidate.useStepMonitor(stepMonitor);
                if (candidate.ignore(stepAsString)) {
                    step = StepCreator.createIgnorableStep(stepAsString);
                    break;
                }
                if (candidate.comment(stepAsString)) {
                    step = StepCreator.createComment(stepAsString);
                    break;
                }
                if (!this.matchesCandidate(stepAsString, previousNonAndStep, candidate)) continue;
                if (candidate.isPending()) {
                    ((StepCreator.PendingStep)step).annotatedOn(candidate.getMethod());
                } else {
                    step = outcome != null ? candidate.createMatchedStepUponOutcome(stepAsString, namedParameters, outcome) : candidate.createMatchedStep(stepAsString, namedParameters);
                    if (candidate.isComposite()) {
                        candidate.addComposedSteps(composedSteps, stepAsString, namedParameters, allCandidates);
                    }
                }
                if (candidate.isAndStep(stepAsString) || candidate.isIgnorableStep(stepAsString)) break;
                previousNonAndStep = stepAsString;
                break;
            }
            if (!this.keywords.isAndStep(stepAsString) && !this.keywords.isIgnorableStep(stepAsString)) {
                previousNonAndStep = stepAsString;
            }
            steps.add(step);
            steps.addAll(composedSteps);
        }
    }

    private boolean matchesCandidate(String step, String previousNonAndStep, StepCandidate candidate) {
        if (previousNonAndStep != null) {
            return candidate.matches(step, previousNonAndStep);
        }
        return candidate.matches(step);
    }
}

