/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.steps.Stepdoc;

public class PrintStreamStepdocReporter
implements StepdocReporter {
    private static final String STEP_MATCHED_BY = "Step ''{0}'' is matched by annotated patterns:";
    private static final String STEP_NOT_MATCHED = "Step ''{0}'' is not matched by any pattern";
    private static final String STEPDOC = "''{0} {1}''";
    private PrintStream output;

    public PrintStreamStepdocReporter() {
        this(System.out);
    }

    public PrintStreamStepdocReporter(PrintStream output) {
        this.output = output;
    }

    @Override
    public void stepdocsMatching(String stepAsString, List<Stepdoc> stepdocs, List<Object> stepsInstances) {
        if (stepdocs.size() > 0) {
            this.output(MessageFormat.format(STEP_MATCHED_BY, stepAsString));
            this.outputStepdocs(stepdocs);
        } else {
            this.output(MessageFormat.format(STEP_NOT_MATCHED, stepAsString));
        }
        this.outputStepsInstances(stepsInstances);
    }

    @Override
    public void stepdocs(List<Stepdoc> stepdocs, List<Object> stepsInstances) {
        this.outputStepdocs(stepdocs);
        this.outputStepsInstances(stepsInstances);
    }

    private void outputStepdocs(List<Stepdoc> stepdocs) {
        for (Stepdoc stepdoc : stepdocs) {
            this.output(MessageFormat.format(STEPDOC, stepdoc.getStartingWord(), stepdoc.getPattern()));
            this.output(stepdoc.getMethodSignature());
        }
    }

    private void outputStepsInstances(List<Object> stepsInstances) {
        if (stepsInstances.size() > 0) {
            this.output("from steps instances:");
            for (Object stepsInstance : stepsInstances) {
                this.output(stepsInstance.getClass().getName());
            }
        } else {
            this.output("as no steps instances are provided");
        }
    }

    private void output(Object object) {
        Format.println(this.output, object);
    }
}

