/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.reporters.ConsoleOutput;

public class ANSIConsoleOutput
extends ConsoleOutput {
    private static final char ESCAPE_CHARACTER = '\u001b';
    private static final String SGR_CONTROL = "m";
    private static final String CODE_SEPARATOR = ";";
    private SGRCode highlightCode = SGRCode.UNDERLINE;
    private Map<String, SGRCode> codes = new HashMap<String, SGRCode>(){
        {
            this.put("narrative", SGRCode.BLUE);
            this.put("beforeScenario", SGRCode.CYAN);
            this.put("successful", SGRCode.GREEN);
            this.put("pending", SGRCode.YELLOW);
            this.put("pendingMethod", SGRCode.YELLOW);
            this.put("notPerformed", SGRCode.MAGENTA);
            this.put("comment", SGRCode.BLUE);
            this.put("ignorable", SGRCode.BLUE);
            this.put("failed", SGRCode.RED);
            this.put("cancelled", SGRCode.RED);
            this.put("restarted", SGRCode.MAGENTA);
        }
    };

    public ANSIConsoleOutput() {
    }

    public ANSIConsoleOutput(Keywords keywords) {
        super(keywords);
    }

    public ANSIConsoleOutput(Properties outputPatterns, Keywords keywords, boolean reportFailureTrace) {
        super(outputPatterns, keywords, reportFailureTrace);
    }

    public void assignCode(String key, SGRCode code) {
        this.codes.put(key, code);
    }

    public void withHighlightCode(SGRCode code) {
        this.highlightCode = code;
    }

    @Override
    protected String format(String key, String defaultPattern, Object ... args) {
        String formatted = super.format(key, defaultPattern, args);
        if (this.codes.containsKey(key)) {
            SGRCode code = this.codes.get(key);
            formatted = this.escapeCodeFor(code) + this.highlightParameterValues(formatted, code) + this.escapeCodeFor(SGRCode.RESET);
        }
        return formatted;
    }

    private String highlightParameterValues(String formatted, SGRCode code) {
        String valueStart = this.lookupPattern("\uff5f", "\uff5f");
        String valueEnd = this.lookupPattern("\uff60", "\uff60");
        return formatted.replaceAll(valueStart, this.escapeCodeFor(this.highlightCode, code)).replaceAll(valueEnd, this.escapeCodeFor(SGRCode.RESET, code));
    }

    private String escapeCodeFor(SGRCode code) {
        return this.controlSequenceInitiator((Object)((Object)code) + SGR_CONTROL);
    }

    private String escapeCodeFor(SGRCode first, SGRCode second) {
        return this.controlSequenceInitiator((Object)((Object)first) + CODE_SEPARATOR + (Object)((Object)second) + SGR_CONTROL);
    }

    private String controlSequenceInitiator(String code) {
        return "\u001b[" + code;
    }

    public static enum SGRCode {
        RESET(0),
        BOLD(1),
        FAINT(2),
        ITALIC(3),
        UNDERLINE(4),
        SLOW_BLINK(5),
        RAPID_BLINK(6),
        NEGATIVE(7),
        CONCEALED(8),
        CROSSED_OUT(9),
        BLACK(30),
        RED(31),
        GREEN(32),
        YELLOW(33),
        BLUE(34),
        MAGENTA(35),
        CYAN(36),
        WHITE(37),
        ON_BLACK(40),
        ON_RED(41),
        ON_GREEN(42),
        ON_YELLOW(43),
        ON_BLUE(44),
        ON_MAGENTA(45),
        ON_CYAN(46),
        ON_WHITE(47),
        BRIGHT_BLACK(90),
        BRIGHT_RED(91),
        BRIGHT_GREEN(92),
        BRIGHT_YELLOW(93),
        BRIGHT_BLUE(94),
        BRIGHT_MAGENTA(95),
        BRIGHT_CYAN(96),
        BRIGHT_WHITE(97);

        private final int code;

        private SGRCode(int code) {
            this.code = code;
        }

        public String toString() {
            return Integer.toString(this.code);
        }
    }
}

