/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jbehave.core.io.StoryNameResolver;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryMap;
import org.jbehave.core.model.StoryMaps;

public class StoryLanes {
    private final StoryMaps storyMaps;
    private final StoryNameResolver nameResolver;

    public StoryLanes(StoryMaps storyMaps, StoryNameResolver nameResolver) {
        this.storyMaps = storyMaps;
        this.nameResolver = nameResolver;
    }

    public List<Story> getStories() {
        ArrayList<Story> stories = new ArrayList<Story>(this.laneStories(""));
        Collections.sort(stories, new Comparator<Story>(){

            @Override
            public int compare(Story o1, Story o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return stories;
    }

    public List<String> getLanes() {
        List<String> lanes = this.storyMaps.getMetaFilters();
        lanes.remove("");
        Collections.sort(lanes);
        return lanes;
    }

    public boolean inLane(String lane, Story story) {
        for (Story laneStory : this.laneStories(lane)) {
            if (!laneStory.getPath().equals(story.getPath())) continue;
            return true;
        }
        return false;
    }

    private List<Story> laneStories(String lane) {
        StoryMap storyMap = this.storyMaps.getMap(lane);
        ArrayList<Story> stories = new ArrayList<Story>();
        if (storyMap == null) {
            for (StoryMap map : this.storyMaps.getMaps()) {
                stories.addAll(map.getStories());
            }
        } else {
            stories.addAll(storyMap.getStories());
        }
        this.nameStories(stories);
        return stories;
    }

    private void nameStories(List<Story> stories) {
        for (Story story : stories) {
            story.namedAs(this.nameResolver.resolveName(story.getPath()));
        }
    }
}

