/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public final class ExamplesTableProperties {
    private static final String HEADER_SEPARATOR = "|";
    private static final String VALUE_SEPARATOR = "|";
    private static final String IGNORABLE_SEPARATOR = "|--";
    private static final String COMMENT_SEPARATOR = "#";
    private static final String HEADER_SEPARATOR_KEY = "headerSeparator";
    private static final String VALUE_SEPARATOR_KEY = "valueSeparator";
    private static final String IGNORABLE_SEPARATOR_KEY = "ignorableSeparator";
    private static final String COMMENT_SEPARATOR_KEY = "commentSeparator";
    private static final String ROW_SEPARATOR = "\n";
    private final Properties properties = new Properties();

    public ExamplesTableProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        if (!this.properties.containsKey(HEADER_SEPARATOR_KEY)) {
            this.properties.setProperty(HEADER_SEPARATOR_KEY, "|");
        }
        if (!this.properties.containsKey(VALUE_SEPARATOR_KEY)) {
            this.properties.setProperty(VALUE_SEPARATOR_KEY, "|");
        }
        if (!this.properties.containsKey(IGNORABLE_SEPARATOR_KEY)) {
            this.properties.setProperty(IGNORABLE_SEPARATOR_KEY, IGNORABLE_SEPARATOR);
        }
        if (!this.properties.containsKey(COMMENT_SEPARATOR_KEY)) {
            this.properties.setProperty(COMMENT_SEPARATOR_KEY, COMMENT_SEPARATOR);
        }
    }

    public ExamplesTableProperties(String propertiesAsString, String defaultHeaderSeparator, String defaultValueSeparator, String defaultIgnorableSeparator) {
        this.properties.setProperty(HEADER_SEPARATOR_KEY, defaultHeaderSeparator);
        this.properties.setProperty(VALUE_SEPARATOR_KEY, defaultValueSeparator);
        this.properties.setProperty(IGNORABLE_SEPARATOR_KEY, defaultIgnorableSeparator);
        try {
            this.properties.load(new ByteArrayInputStream(propertiesAsString.replace(",", System.lineSeparator()).getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getRowSeparator() {
        return ROW_SEPARATOR;
    }

    public String getHeaderSeparator() {
        return this.properties.getProperty(HEADER_SEPARATOR_KEY);
    }

    public String getValueSeparator() {
        return this.properties.getProperty(VALUE_SEPARATOR_KEY);
    }

    public String getIgnorableSeparator() {
        return this.properties.getProperty(IGNORABLE_SEPARATOR_KEY);
    }

    public String getCommentSeparator() {
        return this.properties.getProperty(COMMENT_SEPARATOR_KEY);
    }

    public boolean isTrim() {
        return Boolean.parseBoolean(this.properties.getProperty("trim", "true"));
    }

    public boolean isMetaByRow() {
        return Boolean.parseBoolean(this.properties.getProperty("metaByRow", "false"));
    }

    public String getTransformer() {
        return this.properties.getProperty("transformer");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

