/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.io.StoryNameResolver;
import org.jbehave.core.io.UnderscoredToCapitalized;

public class AncestorDelegatingResolver
implements StoryNameResolver {
    private static final String SEPARATOR = "/";
    private static final String SPACE = " ";
    private final int ancestors;
    private final StoryNameResolver delegate;

    public AncestorDelegatingResolver() {
        this(1);
    }

    public AncestorDelegatingResolver(int ancestors) {
        this(ancestors, new UnderscoredToCapitalized());
    }

    public AncestorDelegatingResolver(int ancestors, StoryNameResolver delegate) {
        this.ancestors = ancestors;
        this.delegate = delegate;
    }

    @Override
    public String resolveName(String path) {
        List<String> reversed = Arrays.asList(path.split(SEPARATOR));
        Collections.reverse(reversed);
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.ancestors + 1; ++i) {
            names.add(0, this.delegate.resolveName(reversed.get(i)));
        }
        return StringUtils.join(names, (String)SPACE);
    }
}

