/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.PrintStream;
import org.jbehave.core.reporters.ANSIConsoleOutput;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.HtmlOutput;
import org.jbehave.core.reporters.HtmlTemplateOutput;
import org.jbehave.core.reporters.IdeOnlyConsoleOutput;
import org.jbehave.core.reporters.JsonOutput;
import org.jbehave.core.reporters.JsonTemplateOutput;
import org.jbehave.core.reporters.PostStoryStatisticsCollector;
import org.jbehave.core.reporters.PrintStreamOutput;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.TxtOutput;
import org.jbehave.core.reporters.XmlOutput;
import org.jbehave.core.reporters.XmlTemplateOutput;

public abstract class Format {
    public static final Format CONSOLE = new Format("CONSOLE"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            return Format.configureReporting(storyReporterBuilder, new ConsoleOutput(storyReporterBuilder.keywords()));
        }
    };
    public static final Format ANSI_CONSOLE = new Format("ANSI_CONSOLE"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            return Format.configureReporting(storyReporterBuilder, new ANSIConsoleOutput(storyReporterBuilder.keywords()));
        }
    };
    public static final Format IDE_CONSOLE = new Format("IDE_CONSOLE"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            return Format.configureReporting(storyReporterBuilder, new IdeOnlyConsoleOutput(storyReporterBuilder.keywords()));
        }
    };
    public static final Format TXT = new Format("TXT"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("txt"));
            return Format.configureReporting(storyReporterBuilder, new TxtOutput(factory.createPrintStream(), storyReporterBuilder.keywords()));
        }
    };
    public static final Format HTML = new Format("HTML"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("html"));
            return Format.configureReporting(storyReporterBuilder, new HtmlOutput(factory.createPrintStream(), storyReporterBuilder.keywords()));
        }
    };
    public static final Format HTML_TEMPLATE = new Format("HTML"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("html"));
            return new HtmlTemplateOutput(factory.getOutputFile(), storyReporterBuilder.keywords());
        }
    };
    public static final Format XML = new Format("XML"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("xml"));
            return Format.configureReporting(storyReporterBuilder, new XmlOutput(factory.createPrintStream(), storyReporterBuilder.keywords()));
        }
    };
    public static final Format XML_TEMPLATE = new Format("XML"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("xml"));
            return new XmlTemplateOutput(factory.getOutputFile(), storyReporterBuilder.keywords());
        }
    };
    public static final Format JSON = new Format("JSON"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("json"));
            return Format.configureReporting(storyReporterBuilder, new JsonOutput(factory.createPrintStream(), storyReporterBuilder.keywords()));
        }
    };
    public static final Format JSON_TEMPLATE = new Format("JSON"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("json"));
            return new JsonTemplateOutput(factory.getOutputFile(), storyReporterBuilder.keywords());
        }
    };
    public static final Format STATS = new Format("STATS"){

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("stats"));
            return new PostStoryStatisticsCollector(factory.createPrintStream());
        }
    };
    private final String name;

    public Format(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public abstract StoryReporter createStoryReporter(FilePrintStreamFactory var1, StoryReporterBuilder var2);

    public static void println(PrintStream writer, Object what) {
        writer.println(what);
    }

    public String toString() {
        return this.name;
    }

    private static PrintStreamOutput configureReporting(StoryReporterBuilder storyReporterBuilder, PrintStreamOutput output) {
        return output.doReportFailureTrace(storyReporterBuilder.reportFailureTrace()).doCompressFailureTrace(storyReporterBuilder.compressFailureTrace());
    }
}

