/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.ResourceLoader;

public class JsonFactory {
    private Keywords keywords;
    private final ResourceLoader resourceLoader;

    public JsonFactory() {
        this(new LocalizedKeywords());
    }

    public JsonFactory(Keywords keywords) {
        this(keywords, new LoadFromClasspath());
    }

    public JsonFactory(ResourceLoader resourceLoader) {
        this(new LocalizedKeywords(), resourceLoader);
    }

    public JsonFactory(Keywords keywords, ResourceLoader resourceLoader) {
        this.keywords = keywords;
        this.resourceLoader = resourceLoader;
    }

    public JsonFactory(Configuration configuration) {
        this.keywords = configuration.keywords();
        this.resourceLoader = configuration.storyLoader();
    }

    public Object createJson(String input, Type type) {
        String jsonAsString = StringUtils.isBlank((CharSequence)input) || this.isJson(input) ? input : this.resourceLoader.loadResourceAsText(input);
        return new Gson().fromJson(jsonAsString, type);
    }

    protected boolean isJson(String input) {
        return input.startsWith("[") && input.endsWith("]") || input.startsWith("{") && input.endsWith("}");
    }

    public void useKeywords(Keywords keywords) {
        this.keywords = keywords;
    }

    public Keywords keywords() {
        return this.keywords;
    }
}

