/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;

public class ExamplesTableFactory {
    private Keywords keywords;
    private final ResourceLoader resourceLoader;
    private final ParameterConverters parameterConverters;
    private final ParameterControls parameterControls;
    private final TableTransformers tableTransformers;

    public ExamplesTableFactory(ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(new LocalizedKeywords(), resourceLoader, tableTransformers);
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(keywords, resourceLoader, new ParameterConverters(resourceLoader, tableTransformers), new ParameterControls(), tableTransformers);
    }

    public ExamplesTableFactory(ResourceLoader resourceLoader, ParameterConverters parameterConverters, ParameterControls parameterControls, TableTransformers tableTransformers) {
        this(new LocalizedKeywords(), resourceLoader, parameterConverters, parameterControls, tableTransformers);
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, ParameterConverters parameterConverters, ParameterControls parameterControls, TableTransformers tableTransformers) {
        this.keywords = keywords;
        this.resourceLoader = resourceLoader;
        this.parameterConverters = parameterConverters;
        this.parameterControls = parameterControls;
        this.tableTransformers = tableTransformers;
    }

    public ExamplesTableFactory(Configuration configuration) {
        this.keywords = configuration.keywords();
        this.resourceLoader = configuration.storyLoader();
        this.parameterConverters = configuration.parameterConverters();
        this.parameterControls = configuration.parameterControls();
        this.tableTransformers = configuration.tableTransformers();
    }

    public ExamplesTable createExamplesTable(String input) {
        String tableAsString = StringUtils.isBlank((CharSequence)input) || this.isTable(input) ? input : this.resourceLoader.loadResourceAsText(input);
        return new ExamplesTable(tableAsString, this.keywords.examplesTableHeaderSeparator(), this.keywords.examplesTableValueSeparator(), this.keywords.examplesTableIgnorableSeparator(), this.parameterConverters, this.parameterControls, this.tableTransformers);
    }

    protected boolean isTable(String input) {
        return input.trim().startsWith(this.keywords.examplesTableHeaderSeparator()) || ExamplesTable.INLINED_PROPERTIES_PATTERN.matcher(input).matches();
    }

    public void useKeywords(Keywords keywords) {
        this.keywords = keywords;
    }

    public Keywords keywords() {
        return this.keywords;
    }
}

