/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.io.IOUtils;
import org.jbehave.core.io.StoryNameResolver;
import org.jbehave.core.model.StoryLanes;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;
import org.jbehave.core.reporters.TemplateProcessor;
import org.jbehave.core.reporters.ViewGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateableViewGenerator
implements ViewGenerator {
    private final StoryNameResolver nameResolver;
    private final TemplateProcessor processor;
    private Properties viewProperties;
    private List<Report> reports = new ArrayList<Report>();

    public TemplateableViewGenerator(StoryNameResolver nameResolver, TemplateProcessor processor) {
        this.nameResolver = nameResolver;
        this.processor = processor;
    }

    @Override
    public Properties defaultViewProperties() {
        Properties properties = new Properties();
        properties.setProperty("encoding", "ISO-8859-1");
        properties.setProperty("decorateNonHtml", "true");
        properties.setProperty("defaultFormats", "stats");
        properties.setProperty("viewDirectory", "view");
        return properties;
    }

    private Properties mergeWithDefault(Properties properties) {
        Properties merged = this.defaultViewProperties();
        merged.putAll((Map<?, ?>)properties);
        return merged;
    }

    private void addDateAndEncoding(Map<String, Object> dataModel) {
        dataModel.put("date", new Date());
        dataModel.put("encoding", this.viewProperties.getProperty("encoding"));
    }

    @Override
    public void generateMapsView(File outputDirectory, StoryMaps storyMaps, Properties viewProperties) {
        this.viewProperties = this.mergeWithDefault(viewProperties);
        String outputName = this.templateResource("viewDirectory") + "/maps.html";
        String mapsTemplate = this.templateResource("maps");
        Map<String, Object> dataModel = this.newDataModel();
        this.addDateAndEncoding(dataModel);
        dataModel.put("storyLanes", new StoryLanes(storyMaps, this.nameResolver));
        this.write(outputDirectory, outputName, mapsTemplate, dataModel);
        this.generateViewsIndex(outputDirectory);
    }

    @Override
    public void generateReportsView(File outputDirectory, List<String> formats, Properties viewProperties) {
        this.viewProperties = this.mergeWithDefault(viewProperties);
        String outputName = this.templateResource("viewDirectory") + "/reports.html";
        String reportsTemplate = this.templateResource("reports");
        List<String> mergedFormats = this.mergeFormatsWithDefaults(formats);
        this.reports = this.createReports(this.readReportFiles(outputDirectory, outputName, mergedFormats));
        Map<String, Object> dataModel = this.newDataModel();
        this.addDateAndEncoding(dataModel);
        dataModel.put("timeFormatter", new TimeFormatter());
        dataModel.put("reportsTable", new ReportsTable(this.reports, this.nameResolver));
        this.write(outputDirectory, outputName, reportsTemplate, dataModel);
        this.generateViewsIndex(outputDirectory);
    }

    private void generateViewsIndex(File outputDirectory) {
        String outputName = this.templateResource("viewDirectory") + "/index.html";
        String viewsTemplate = this.templateResource("views");
        Map<String, Object> dataModel = this.newDataModel();
        this.addDateAndEncoding(dataModel);
        this.write(outputDirectory, outputName, viewsTemplate, dataModel);
    }

    @Override
    public ReportsCount getReportsCount() {
        int stories = this.countStoriesWithScenarios();
        int storiesNotAllowed = this.count("notAllowed", this.reports);
        int storiesPending = this.count("pending", this.reports);
        int scenarios = this.count("scenarios", this.reports);
        int scenariosFailed = this.count("scenariosFailed", this.reports);
        int scenariosNotAllowed = this.count("scenariosNotAllowed", this.reports);
        int scenariosPending = this.count("scenariosPending", this.reports);
        int stepsFailed = this.count("stepsFailed", this.reports);
        return new ReportsCount(stories, storiesNotAllowed, storiesPending, scenarios, scenariosFailed, scenariosNotAllowed, scenariosPending, stepsFailed);
    }

    private int countStoriesWithScenarios() {
        int storyCount = 0;
        for (Report report : this.reports) {
            Map<String, Integer> stats = report.getStats();
            if (!stats.containsKey("scenarios") || stats.get("scenarios") <= 0) continue;
            ++storyCount;
        }
        return storyCount;
    }

    int count(String event, Collection<Report> reports) {
        int count = 0;
        for (Report report : reports) {
            Properties stats = report.asProperties("stats");
            if (!stats.containsKey(event)) continue;
            count += Integer.parseInt((String)stats.get(event));
        }
        return count;
    }

    private List<String> mergeFormatsWithDefaults(List<String> formats) {
        ArrayList<String> merged = new ArrayList<String>();
        merged.addAll(Arrays.asList(this.templateResource("defaultFormats").split(",")));
        merged.addAll(formats);
        return merged;
    }

    List<Report> createReports(Map<String, List<File>> reportFiles) {
        try {
            String decoratedTemplate = this.templateResource("decorated");
            String nonDecoratedTemplate = this.templateResource("nonDecorated");
            String viewDirectory = this.templateResource("viewDirectory");
            boolean decorateNonHtml = Boolean.valueOf(this.templateResource("decorateNonHtml"));
            ArrayList<Report> reports = new ArrayList<Report>();
            for (String name : reportFiles.keySet()) {
                HashMap<String, File> filesByFormat = new HashMap<String, File>();
                for (File file : reportFiles.get(name)) {
                    String fileName = file.getName();
                    String format = FilenameUtils.getExtension((String)fileName);
                    Map<String, Object> dataModel = this.newDataModel();
                    dataModel.put("name", name);
                    dataModel.put("body", IOUtils.toString(new FileReader(file), true));
                    dataModel.put("format", format);
                    File outputDirectory = file.getParentFile();
                    String outputName = viewDirectory + "/" + fileName;
                    String template = decoratedTemplate;
                    if (!format.equals("html")) {
                        if (decorateNonHtml) {
                            outputName = outputName + ".html";
                        } else {
                            template = nonDecoratedTemplate;
                        }
                    }
                    File written = this.write(outputDirectory, outputName, template, dataModel);
                    filesByFormat.put(format, written);
                }
                reports.add(new Report(name, filesByFormat));
            }
            return reports;
        }
        catch (Exception e) {
            throw new ReportCreationFailed(reportFiles, e);
        }
    }

    SortedMap<String, List<File>> readReportFiles(File outputDirectory, final String outputName, final List<String> formats) {
        String[] fileNames;
        TreeMap<String, List<File>> reportFiles = new TreeMap<String, List<File>>();
        if (outputDirectory == null || !outputDirectory.exists()) {
            return reportFiles;
        }
        for (String fileName : fileNames = outputDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equals(outputName) && this.hasFormats(name, formats);
            }

            private boolean hasFormats(String name, List<String> formats2) {
                for (String format : formats2) {
                    if (!name.endsWith(format)) continue;
                    return true;
                }
                return false;
            }
        })) {
            String name = FilenameUtils.getBaseName((String)fileName);
            ArrayList<File> filesByName = (ArrayList<File>)reportFiles.get(name);
            if (filesByName == null) {
                filesByName = new ArrayList<File>();
                reportFiles.put(name, filesByName);
            }
            filesByName.add(new File(outputDirectory, fileName));
        }
        return reportFiles;
    }

    private File write(File outputDirectory, String outputName, String resource, Map<String, Object> dataModel) {
        try {
            File file = new File(outputDirectory, outputName);
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            this.processor.process(resource, dataModel, writer);
            ((Writer)writer).close();
            return file;
        }
        catch (Exception e) {
            throw new ViewGenerationFailedForTemplate(resource, e);
        }
    }

    private String templateResource(String format) {
        return this.viewProperties.getProperty(format);
    }

    private Map<String, Object> newDataModel() {
        return new HashMap<String, Object>();
    }

    public static class TimeFormatter {
        public String formatMillis(long millis) {
            int second = 1000;
            int minute = 60 * second;
            int hour = 60 * minute;
            long hours = millis / (long)hour;
            long minutes = millis % (long)hour / (long)minute;
            long seconds = millis % (long)hour % (long)minute / (long)second;
            long milliseconds = millis % (long)hour % (long)minute % (long)second;
            Formatter formatter = new Formatter();
            String result = formatter.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, milliseconds).toString();
            formatter.close();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Report
    implements Comparable<Report> {
        private final String path;
        private final Map<String, File> filesByFormat;
        private Map<String, Integer> stats;
        private String name;

        public Report(String path, Map<String, File> filesByFormat) {
            this(path, filesByFormat, null);
        }

        public Report(String path, Map<String, File> filesByFormat, Map<String, Integer> stats) {
            this.path = path;
            this.filesByFormat = filesByFormat;
            this.stats = stats;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name != null ? this.name : this.path;
        }

        public void nameAs(String name) {
            this.name = name;
        }

        public Map<String, File> getFilesByFormat() {
            return this.filesByFormat;
        }

        public Properties asProperties(String format) {
            Properties p = new Properties();
            File stats = this.filesByFormat.get(format);
            try {
                FileInputStream inputStream = new FileInputStream(stats);
                p.load(inputStream);
                ((InputStream)inputStream).close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return p;
        }

        public Map<String, Integer> getStats() {
            if (this.stats == null) {
                Properties p = this.asProperties("stats");
                this.stats = new HashMap<String, Integer>();
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.stats.put(key, this.valueOf(key, p));
                }
            }
            return this.stats;
        }

        private Integer valueOf(String key, Properties p) {
            try {
                return Integer.valueOf(p.getProperty(key));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public int compareTo(Report that) {
            return CompareToBuilder.reflectionCompare((Object)this.getName(), (Object)that.getName());
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.path).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReportsTable {
        private final Map<String, Report> reports = new HashMap<String, Report>();
        private final StoryNameResolver nameResolver;

        public ReportsTable(List<Report> reports, StoryNameResolver nameResolver) {
            this.nameResolver = nameResolver;
            this.index(reports);
            this.addTotalsReport();
        }

        private void index(List<Report> reports) {
            for (Report report : reports) {
                report.nameAs(this.nameResolver.resolveName(report.getPath()));
                this.reports.put(report.getName(), report);
            }
        }

        private void addTotalsReport() {
            Report report = this.totals(this.reports.values());
            report.nameAs(this.nameResolver.resolveName(report.getPath()));
            this.reports.put(report.getName(), report);
        }

        private Report totals(Collection<Report> values) {
            HashMap<String, Integer> totals = new HashMap<String, Integer>();
            for (Report report : values) {
                Map<String, Integer> stats = report.getStats();
                for (String key : stats.keySet()) {
                    Integer total = (Integer)totals.get(key);
                    if (total == null) {
                        total = 0;
                    }
                    total = total + stats.get(key);
                    totals.put(key, total);
                }
            }
            return new Report("Totals", new HashMap<String, File>(), totals);
        }

        public List<Report> getReports() {
            ArrayList<Report> list = new ArrayList<Report>(this.reports.values());
            Collections.sort(list);
            return list;
        }

        public List<String> getReportNames() {
            ArrayList<String> list = new ArrayList<String>(this.reports.keySet());
            Collections.sort(list);
            return list;
        }

        public Report getReport(String name) {
            return this.reports.get(name);
        }
    }

    public static class ViewGenerationFailedForTemplate
    extends RuntimeException {
        public ViewGenerationFailedForTemplate(String resource, Exception cause) {
            super(resource, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReportCreationFailed
    extends RuntimeException {
        public ReportCreationFailed(Map<String, List<File>> reportFiles, Exception cause) {
            super("Report creation failed from file " + reportFiles, cause);
        }
    }
}

