/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.parsers.StoryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexStoryParser
implements StoryParser {
    private static final String NONE = "";
    private final Keywords keywords;
    private final ExamplesTableFactory tableFactory;

    public RegexStoryParser() {
        this(new LocalizedKeywords());
    }

    public RegexStoryParser(Keywords keywords) {
        this(keywords, new ExamplesTableFactory(keywords));
    }

    public RegexStoryParser(ExamplesTableFactory tableFactory) {
        this(tableFactory.keywords(), tableFactory);
    }

    public RegexStoryParser(Keywords keywords, ExamplesTableFactory tableFactory) {
        this.keywords = keywords;
        this.tableFactory = tableFactory;
        this.tableFactory.useKeywords(keywords);
    }

    public RegexStoryParser(Configuration configuration) {
        this.keywords = configuration.keywords();
        this.tableFactory = new ExamplesTableFactory(configuration);
    }

    @Override
    public Story parseStory(String storyAsText) {
        return this.parseStory(storyAsText, null);
    }

    @Override
    public Story parseStory(String storyAsText, String storyPath) {
        Description description = this.parseDescriptionFrom(storyAsText);
        Meta meta = this.parseStoryMetaFrom(storyAsText);
        Narrative narrative = this.parseNarrativeFrom(storyAsText);
        GivenStories givenStories = this.parseGivenStories(storyAsText);
        Lifecycle lifecycle = this.parseLifecycle(storyAsText);
        List<Scenario> scenarios = this.parseScenariosFrom(storyAsText);
        Story story = new Story(storyPath, description, meta, narrative, givenStories, lifecycle, scenarios);
        if (storyPath != null) {
            story.namedAs(new File(storyPath).getName());
        }
        return story;
    }

    private Description parseDescriptionFrom(String storyAsText) {
        Matcher findingDescription = this.patternToPullDescriptionIntoGroupOne().matcher(storyAsText);
        if (findingDescription.matches()) {
            return new Description(findingDescription.group(1).trim());
        }
        return Description.EMPTY;
    }

    private Meta parseStoryMetaFrom(String storyAsText) {
        Matcher findingMeta = this.patternToPullStoryMetaIntoGroupOne().matcher(this.preScenarioText(storyAsText));
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return Meta.createMeta(meta, this.keywords);
        }
        return Meta.EMPTY;
    }

    private String preScenarioText(String storyAsText) {
        String[] split = storyAsText.split(this.keywords.scenario());
        return split.length > 0 ? split[0] : storyAsText;
    }

    private Narrative parseNarrativeFrom(String storyAsText) {
        Matcher findingNarrative = this.patternToPullNarrativeIntoGroupOne().matcher(storyAsText);
        if (findingNarrative.matches()) {
            String narrative = findingNarrative.group(1).trim();
            return this.createNarrative(narrative);
        }
        return Narrative.EMPTY;
    }

    private Narrative createNarrative(String narrative) {
        Matcher findingElements = this.patternToPullNarrativeElementsIntoGroups().matcher(narrative);
        if (findingElements.matches()) {
            String inOrderTo = findingElements.group(1).trim();
            String asA = findingElements.group(2).trim();
            String iWantTo = findingElements.group(3).trim();
            return new Narrative(inOrderTo, asA, iWantTo);
        }
        Matcher findingAlternativeElements = this.patternToPullAlternativeNarrativeElementsIntoGroups().matcher(narrative);
        if (findingAlternativeElements.matches()) {
            String asA = findingAlternativeElements.group(1).trim();
            String iWantTo = findingAlternativeElements.group(2).trim();
            String soThat = findingAlternativeElements.group(3).trim();
            return new Narrative(NONE, asA, iWantTo, soThat);
        }
        return Narrative.EMPTY;
    }

    private GivenStories parseGivenStories(String storyAsText) {
        Matcher findingGivenStories;
        String scenarioKeyword = this.keywords.scenario();
        String beforeScenario = NONE;
        if (StringUtils.contains((String)storyAsText, (String)scenarioKeyword)) {
            beforeScenario = StringUtils.substringBefore((String)storyAsText, (String)scenarioKeyword);
        }
        String givenStories = (findingGivenStories = this.patternToPullStoryGivenStoriesIntoGroupOne().matcher(beforeScenario)).find() ? findingGivenStories.group(1).trim() : NONE;
        return new GivenStories(givenStories);
    }

    private Lifecycle parseLifecycle(String storyAsText) {
        Matcher findingLifecycle;
        String scenarioKeyword = this.keywords.scenario();
        String beforeScenario = NONE;
        if (StringUtils.contains((String)storyAsText, (String)scenarioKeyword)) {
            beforeScenario = StringUtils.substringBefore((String)storyAsText, (String)scenarioKeyword);
        }
        String lifecycle = (findingLifecycle = this.patternToPullLifecycleIntoGroupOne().matcher(beforeScenario)).find() ? findingLifecycle.group(1).trim() : NONE;
        Matcher findingBeforeAndAfter = Pattern.compile(".*" + this.keywords.before() + "(.*)\\s*" + this.keywords.after() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingBeforeAndAfter.matches()) {
            List<String> beforeSteps = this.findSteps(this.startingWithNL(findingBeforeAndAfter.group(1).trim()));
            List<String> afterSteps = this.findSteps(this.startingWithNL(findingBeforeAndAfter.group(2).trim()));
            return new Lifecycle(beforeSteps, afterSteps);
        }
        Matcher findingBefore = Pattern.compile(".*" + this.keywords.before() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingBefore.matches()) {
            List<String> beforeSteps = this.findSteps(this.startingWithNL(findingBefore.group(1).trim()));
            ArrayList<String> afterSteps = new ArrayList<String>();
            return new Lifecycle(beforeSteps, afterSteps);
        }
        Matcher findingAfter = Pattern.compile(".*" + this.keywords.after() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingAfter.matches()) {
            ArrayList<String> beforeSteps = new ArrayList<String>();
            List<String> afterSteps = this.findSteps(this.startingWithNL(findingAfter.group(1).trim()));
            return new Lifecycle(beforeSteps, afterSteps);
        }
        return Lifecycle.EMPTY;
    }

    private List<Scenario> parseScenariosFrom(String storyAsText) {
        ArrayList<Scenario> parsed = new ArrayList<Scenario>();
        for (String scenarioAsText : this.splitScenarios(storyAsText)) {
            parsed.add(this.parseScenario(scenarioAsText));
        }
        return parsed;
    }

    private List<String> splitScenarios(String storyAsText) {
        ArrayList<String> scenarios = new ArrayList<String>();
        String scenarioKeyword = this.keywords.scenario();
        if (StringUtils.contains((String)storyAsText, (String)scenarioKeyword)) {
            storyAsText = StringUtils.substringAfter((String)storyAsText, (String)scenarioKeyword);
        }
        for (String scenarioAsText : storyAsText.split(scenarioKeyword)) {
            if (scenarioAsText.trim().length() <= 0) continue;
            scenarios.add(scenarioKeyword + "\n" + scenarioAsText);
        }
        return scenarios;
    }

    private Scenario parseScenario(String scenarioAsText) {
        String title = this.findScenarioTitle(scenarioAsText);
        String scenarioWithoutKeyword = StringUtils.removeStart((String)scenarioAsText, (String)this.keywords.scenario()).trim();
        String scenarioWithoutTitle = StringUtils.removeStart((String)scenarioWithoutKeyword, (String)title);
        scenarioWithoutTitle = this.startingWithNL(scenarioWithoutTitle);
        Meta meta = this.findScenarioMeta(scenarioWithoutTitle);
        ExamplesTable examplesTable = this.findExamplesTable(scenarioWithoutTitle);
        GivenStories givenStories = this.findScenarioGivenStories(scenarioWithoutTitle);
        if (givenStories.requireParameters()) {
            givenStories.useExamplesTable(examplesTable);
        }
        List<String> steps = this.findSteps(scenarioWithoutTitle);
        return new Scenario(title, meta, givenStories, examplesTable, steps);
    }

    private String startingWithNL(String text) {
        if (!text.startsWith("\n")) {
            return "\n" + text;
        }
        return text;
    }

    private String findScenarioTitle(String scenarioAsText) {
        Matcher findingTitle = this.patternToPullScenarioTitleIntoGroupOne().matcher(scenarioAsText);
        return findingTitle.find() ? findingTitle.group(1).trim() : NONE;
    }

    private Meta findScenarioMeta(String scenarioAsText) {
        Matcher findingMeta = this.patternToPullScenarioMetaIntoGroupOne().matcher(scenarioAsText);
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return Meta.createMeta(meta, this.keywords);
        }
        return Meta.EMPTY;
    }

    private ExamplesTable findExamplesTable(String scenarioAsText) {
        Matcher findingTable = this.patternToPullExamplesTableIntoGroupOne().matcher(scenarioAsText);
        String tableInput = findingTable.find() ? findingTable.group(1).trim() : NONE;
        return this.tableFactory.createExamplesTable(tableInput);
    }

    private GivenStories findScenarioGivenStories(String scenarioAsText) {
        Matcher findingGivenStories = this.patternToPullScenarioGivenStoriesIntoGroupOne().matcher(scenarioAsText);
        String givenStories = findingGivenStories.find() ? findingGivenStories.group(1).trim() : NONE;
        return new GivenStories(givenStories);
    }

    private List<String> findSteps(String scenarioAsText) {
        Matcher matcher = this.patternToPullStepsIntoGroupOne().matcher(scenarioAsText);
        ArrayList<String> steps = new ArrayList<String>();
        int startAt = 0;
        while (matcher.find(startAt)) {
            steps.add(StringUtils.substringAfter((String)matcher.group(1), (String)"\n"));
            startAt = matcher.start(4);
        }
        return steps;
    }

    private Pattern patternToPullDescriptionIntoGroupOne() {
        String metaOrNarrativeOrLifecycleOrScenario = this.concatenateWithOr(this.keywords.meta(), this.keywords.narrative(), this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile("(.*?)(" + metaOrNarrativeOrLifecycleOrScenario + ").*", 32);
    }

    private Pattern patternToPullStoryMetaIntoGroupOne() {
        String narrativeOrGivenStories = this.concatenateWithOr(this.keywords.narrative(), this.keywords.givenStories());
        return Pattern.compile(".*" + this.keywords.meta() + "(.*?)\\s*(\\Z|" + narrativeOrGivenStories + ").*", 32);
    }

    private Pattern patternToPullNarrativeIntoGroupOne() {
        String givenStoriesOrLifecycleOrScenario = this.concatenateWithOr(this.keywords.givenStories(), this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile(".*" + this.keywords.narrative() + "(.*?)\\s*(" + givenStoriesOrLifecycleOrScenario + ").*", 32);
    }

    private Pattern patternToPullNarrativeElementsIntoGroups() {
        return Pattern.compile(".*" + this.keywords.inOrderTo() + "(.*)\\s*" + this.keywords.asA() + "(.*)\\s*" + this.keywords.iWantTo() + "(.*)", 32);
    }

    private Pattern patternToPullAlternativeNarrativeElementsIntoGroups() {
        return Pattern.compile(".*" + this.keywords.asA() + "(.*)\\s*" + this.keywords.iWantTo() + "(.*)\\s*" + this.keywords.soThat() + "(.*)", 32);
    }

    private Pattern patternToPullStoryGivenStoriesIntoGroupOne() {
        String lifecycleOrScenario = this.concatenateWithOr(this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile(".*" + this.keywords.givenStories() + "(.*?)\\s*(\\Z|" + lifecycleOrScenario + ").*", 32);
    }

    private Pattern patternToPullLifecycleIntoGroupOne() {
        return Pattern.compile(".*" + this.keywords.lifecycle() + "\\s*(.*)", 32);
    }

    private Pattern patternToPullScenarioTitleIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(this.keywords.scenario() + "((.)*?)\\s*(" + this.keywords.meta() + "|" + startingWords + ").*", 32);
    }

    private Pattern patternToPullScenarioMetaIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(".*" + this.keywords.meta() + "(.*?)\\s*(" + this.keywords.givenStories() + "|" + startingWords + ").*", 32);
    }

    private Pattern patternToPullScenarioGivenStoriesIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile("\\n" + this.keywords.givenStories() + "((.|\\n)*?)\\s*(" + startingWords + ").*", 32);
    }

    private Pattern patternToPullStepsIntoGroupOne() {
        String initialStartingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        String followingStartingWords = this.concatenateWithOr("\\n", "\\s", this.keywords.startingWords());
        return Pattern.compile("((" + initialStartingWords + ")\\s(.)*?)\\s*(\\Z|" + followingStartingWords + "|\\n" + this.keywords.examplesTable() + ")", 32);
    }

    private Pattern patternToPullExamplesTableIntoGroupOne() {
        return Pattern.compile("\\n" + this.keywords.examplesTable() + "\\s*(.*)", 32);
    }

    private String concatenateWithOr(String ... keywords) {
        return this.concatenateWithOr((String)null, (String)null, keywords);
    }

    private String concatenateWithOr(String beforeKeyword, String afterKeyword, String[] keywords) {
        StringBuilder builder = new StringBuilder();
        String before = beforeKeyword != null ? beforeKeyword : NONE;
        String after = afterKeyword != null ? afterKeyword : NONE;
        for (String keyword : keywords) {
            builder.append(before).append(keyword).append(after).append("|");
        }
        return StringUtils.chomp((String)builder.toString(), (String)"|");
    }
}

