/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class StoryLocation {
    private final URL codeLocation;
    private final String storyPath;
    private final boolean storyPathIsURL;

    public StoryLocation(URL codeLocation, String storyPath) {
        this.codeLocation = codeLocation;
        this.storyPath = storyPath;
        this.storyPathIsURL = this.isURL(storyPath);
    }

    public URL getCodeLocation() {
        return this.codeLocation;
    }

    public String getStoryPath() {
        return this.storyPath;
    }

    public String getURL() {
        if (this.storyPathIsURL) {
            return this.storyPath;
        }
        return this.codeLocation.toExternalForm() + this.storyPath;
    }

    public String getPath() {
        if (this.storyPathIsURL) {
            return StringUtils.removeStart((String)this.storyPath, (String)this.codeLocation.toExternalForm());
        }
        return this.storyPath;
    }

    private boolean isURL(String path) {
        try {
            new URL(path);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

