/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.FilteredStory;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryManager {
    private final Configuration configuration;
    private final EmbedderControls embedderControls;
    private final EmbedderMonitor embedderMonitor;
    private final ExecutorService executorService;
    private final InjectableStepsFactory stepsFactory;
    private final PerformableTree performableTree;
    private final Map<String, RunningStory> runningStories = new HashMap<String, RunningStory>();
    private final Map<MetaFilter, List<Story>> excludedStories = new HashMap<MetaFilter, List<Story>>();
    private PerformableTree.RunContext context;

    public StoryManager(Configuration configuration, InjectableStepsFactory stepsFactory, EmbedderControls embedderControls, EmbedderMonitor embedderMonitor, ExecutorService executorService, PerformableTree performableTree) {
        this.configuration = configuration;
        this.embedderControls = embedderControls;
        this.embedderMonitor = embedderMonitor;
        this.executorService = executorService;
        this.stepsFactory = stepsFactory;
        this.performableTree = performableTree;
    }

    public Story storyOfPath(String storyPath) {
        return this.performableTree.storyOfPath(this.configuration, storyPath);
    }

    public Story storyOfText(String storyAsText, String storyId) {
        return this.performableTree.storyOfText(this.configuration, storyAsText, storyId);
    }

    public void clear() {
        this.runningStories.clear();
    }

    public PerformableTree.PerformableRoot performableRoot() {
        return this.performableTree.getRoot();
    }

    public List<StoryOutcome> outcomes() {
        ArrayList<StoryOutcome> outcomes = new ArrayList<StoryOutcome>();
        for (RunningStory story : this.runningStories.values()) {
            outcomes.add(new StoryOutcome(story));
        }
        return outcomes;
    }

    public void runStories(List<String> storyPaths, MetaFilter filter, BatchFailures failures) {
        this.context = this.performableTree.newRunContext(this.configuration, this.stepsFactory, filter, failures);
        this.performableTree.addStories(this.context, storyPaths);
        this.performStories(this.context, this.performableTree, storyPaths);
        failures.putAll(this.context.getFailures());
    }

    public void performStories(PerformableTree.RunContext context, PerformableTree performableTree, List<String> storyPaths) {
        performableTree.performBeforeOrAfterStories(context, StepCollector.Stage.BEFORE);
        this.runningStoriesAsPaths(context, storyPaths);
        this.waitUntilAllDoneOrFailed(context);
        MetaFilter filter = context.filter();
        List<Story> notAllowed = this.notAllowedBy(filter);
        if (!notAllowed.isEmpty()) {
            this.embedderMonitor.storiesNotAllowed(notAllowed, filter, this.embedderControls.verboseFiltering());
        }
        performableTree.performBeforeOrAfterStories(context, StepCollector.Stage.AFTER);
    }

    public Map<String, RunningStory> runningStoriesAsPaths(PerformableTree.RunContext context, List<String> storyPaths) {
        for (String storyPath : storyPaths) {
            this.filterRunning(context, this.storyOfPath(storyPath));
        }
        return this.runningStories;
    }

    public Map<String, RunningStory> runningStories(PerformableTree.RunContext context, List<Story> stories) {
        for (Story story : stories) {
            this.filterRunning(context, story);
        }
        return this.runningStories;
    }

    private void filterRunning(PerformableTree.RunContext context, Story story) {
        FilteredStory filteredStory = context.filter(story);
        if (filteredStory.allowed()) {
            this.runningStories.put(story.getPath(), this.runningStory(story));
        } else {
            this.notAllowedBy(context.getFilter()).add(story);
        }
    }

    public List<Story> notAllowedBy(MetaFilter filter) {
        List<Story> stories = this.excludedStories.get(filter);
        if (stories == null) {
            stories = new ArrayList<Story>();
            this.excludedStories.put(filter, stories);
        }
        return stories;
    }

    public RunningStory runningStory(Story story) {
        return this.submit(new EnqueuedStory(this.performableTree, this.context, this.embedderControls, this.embedderMonitor, story));
    }

    public void waitUntilAllDoneOrFailed(PerformableTree.RunContext context) {
        Future<ThrowableStory> future;
        long start = System.currentTimeMillis();
        boolean allDone = false;
        while (!allDone) {
            allDone = true;
            for (RunningStory runningStory : this.runningStories.values()) {
                future = runningStory.getFuture();
                if (!future.isDone()) {
                    long timeoutInSecs;
                    allDone = false;
                    long durationInSecs = this.storyDurationInSecs(start);
                    if (durationInSecs <= (timeoutInSecs = this.embedderControls.storyTimeoutInSecs())) break;
                    Story story = runningStory.getStory();
                    StoryDuration storyDuration = new StoryDuration(durationInSecs, timeoutInSecs);
                    this.embedderMonitor.storyTimeout(story, storyDuration);
                    context.cancelStory(story, storyDuration);
                    future.cancel(true);
                    if (!this.embedderControls.failOnStoryTimeout()) break;
                    StoryTimeout timeout = new StoryTimeout(durationInSecs + "s > " + timeoutInSecs + "s");
                    throw new StoryExecutionFailed(story.getPath(), timeout);
                }
                Story story = runningStory.getStory();
                try {
                    ThrowableStory throwableStory = future.get();
                    Throwable throwable = throwableStory.getThrowable();
                    if (throwable == null) continue;
                    context.addFailure(story.getPath(), throwable);
                    if (this.embedderControls.ignoreFailureInStories()) continue;
                }
                catch (Throwable e) {
                    context.addFailure(story.getPath(), e);
                    if (this.embedderControls.ignoreFailureInStories()) continue;
                }
                break;
            }
            this.tickTock();
        }
        for (RunningStory runningStory : this.runningStories.values()) {
            future = runningStory.getFuture();
            if (future.isDone()) continue;
            future.cancel(true);
        }
    }

    private void tickTock() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long storyDurationInSecs(long start) {
        return (System.currentTimeMillis() - start) / 1000L;
    }

    private synchronized RunningStory submit(EnqueuedStory enqueuedStory) {
        return new RunningStory(enqueuedStory.getStory(), this.executorService.submit(enqueuedStory));
    }

    public static class StoryOutcome {
        private String path;
        private Boolean done;
        private Boolean failed;

        public StoryOutcome(RunningStory story) {
            this.path = story.getStory().getPath();
            this.done = story.isDone();
            this.failed = story.isFailed();
        }

        public String getPath() {
            return this.path;
        }

        public Boolean isDone() {
            return this.done;
        }

        public Boolean isFailed() {
            return this.failed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunningStory {
        private Story story;
        private Future<ThrowableStory> future;

        public RunningStory(Story story, Future<ThrowableStory> future) {
            this.story = story;
            this.future = future;
        }

        public Future<ThrowableStory> getFuture() {
            return this.future;
        }

        public Story getStory() {
            return this.story;
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public boolean isFailed() {
            if (this.isDone()) {
                try {
                    return this.future.get().getThrowable() != null;
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static class ThrowableStory {
        private Story story;
        private Throwable throwable;

        public ThrowableStory(Story story, Throwable throwable) {
            this.story = story;
            this.throwable = throwable;
        }

        public Story getStory() {
            return this.story;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    public static class StoryTimeout
    extends RuntimeException {
        public StoryTimeout(String message) {
            super(message);
        }
    }

    public static class StoryExecutionFailed
    extends RuntimeException {
        public StoryExecutionFailed(String storyPath, Throwable failure) {
            super(storyPath, failure);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnqueuedStory
    implements Callable<ThrowableStory> {
        private final PerformableTree performableTree;
        private final PerformableTree.RunContext context;
        private final EmbedderControls embedderControls;
        private final EmbedderMonitor embedderMonitor;
        private final Story story;

        public EnqueuedStory(PerformableTree performableTree, PerformableTree.RunContext context, EmbedderControls embedderControls, EmbedderMonitor embedderMonitor, Story story) {
            this.performableTree = performableTree;
            this.context = context;
            this.embedderControls = embedderControls;
            this.embedderMonitor = embedderMonitor;
            this.story = story;
        }

        @Override
        public ThrowableStory call() throws Exception {
            String storyPath = this.story.getPath();
            try {
                this.embedderMonitor.runningStory(storyPath);
                this.performableTree.perform(this.context, this.story);
            }
            catch (Throwable e) {
                if (this.embedderControls.ignoreFailureInStories()) {
                    this.embedderMonitor.storyFailed(storyPath, e);
                }
                return new ThrowableStory(this.story, new StoryExecutionFailed(storyPath, e));
            }
            return new ThrowableStory(this.story, null);
        }

        public Story getStory() {
            return this.story;
        }
    }
}

