/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.context;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import org.apache.commons.lang.StringEscapeUtils;
import org.jbehave.core.context.ContextView;

public class JFrameContextView
implements ContextView {
    protected JFrame frame;
    protected JLabel label;
    protected int width;
    protected int height;
    protected int x;
    protected int y;

    public JFrameContextView() {
        this.sized(380, 85);
        this.located(0, 0);
    }

    public JFrameContextView sized(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public JFrameContextView located(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public synchronized void show(String story, String scenario, String step) {
        if (this.frame == null) {
            this.initialize();
        }
        this.label.setText(this.formatText(story, scenario, step));
        try {
            TimeUnit.MILLISECONDS.sleep(this.pauseInMillis());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    protected String formatText(String story, String scenario, String step) {
        return MessageFormat.format(this.labelTemplate(), story != null ? StringEscapeUtils.escapeHtml((String)story) : "", scenario != null ? StringEscapeUtils.escapeHtml((String)scenario) : "", StringEscapeUtils.escapeHtml((String)step));
    }

    protected String labelTemplate() {
        return "<html><h3>{0}</h3><h4>{1}</h4><p>{2}</p></html>";
    }

    protected long pauseInMillis() {
        return 250L;
    }

    public synchronized void close() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
            this.label = null;
        }
    }

    protected void initialize() {
        this.frame = new JFrame();
        this.label = new JLabel();
        this.frame.setAlwaysOnTop(true);
        this.frame.setSize(this.width, this.height);
        this.frame.setLocation(this.x, this.y);
        this.frame.setUndecorated(true);
        JPanel panel = new JPanel();
        this.frame.setContentPane(panel);
        panel.setLayout(new BorderLayout());
        this.label.setBorder(new EmptyBorder(3, 3, 3, 3));
        panel.add((Component)this.label, "Center");
        MouseInputAdapter mia = new MouseInputAdapter(){
            private Point mousePressedScreenCoords;
            private Point mousePressedCompCoords;

            public void mouseReleased(MouseEvent e) {
                this.mousePressedScreenCoords = null;
                this.mousePressedCompCoords = null;
            }

            public void mousePressed(MouseEvent e) {
                this.mousePressedScreenCoords = e.getLocationOnScreen();
                this.mousePressedCompCoords = e.getPoint();
            }

            public void mouseDragged(MouseEvent e) {
                Point currCoords = e.getLocationOnScreen();
                JFrameContextView.this.x = this.mousePressedScreenCoords.x + (currCoords.x - this.mousePressedScreenCoords.x) - this.mousePressedCompCoords.x;
                JFrameContextView.this.y = this.mousePressedScreenCoords.y + (currCoords.y - this.mousePressedScreenCoords.y) - this.mousePressedCompCoords.y;
                JFrameContextView.this.frame.setLocation(JFrameContextView.this.x, JFrameContextView.this.y);
            }
        };
        this.frame.addMouseListener(mia);
        this.frame.addMouseMotionListener(mia);
        this.frame.setVisible(true);
    }
}

