/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lifecycle {
    public static final Lifecycle EMPTY = new Lifecycle();
    private Steps before;
    private Steps[] after;

    public Lifecycle() {
        this(Steps.EMPTY, new Steps[0]);
    }

    public Lifecycle(Steps before, Steps ... after) {
        this.before = before;
        this.after = after;
    }

    public List<String> getBeforeSteps() {
        return this.before.steps;
    }

    public List<String> getAfterSteps() {
        ArrayList<String> afterSteps = new ArrayList<String>();
        for (Steps steps : this.after) {
            afterSteps.addAll(steps.steps);
        }
        return afterSteps;
    }

    public Set<AfterScenario.Outcome> getOutcomes() {
        LinkedHashSet<AfterScenario.Outcome> outcomes = new LinkedHashSet<AfterScenario.Outcome>();
        for (Steps steps : this.after) {
            outcomes.add(steps.outcome);
        }
        return outcomes;
    }

    public List<String> getAfterSteps(AfterScenario.Outcome outcome) {
        ArrayList<String> afterSteps = new ArrayList<String>();
        for (Steps steps : this.after) {
            if (!outcome.equals((Object)steps.outcome)) continue;
            afterSteps.addAll(steps.steps);
        }
        return afterSteps;
    }

    public boolean isEmpty() {
        return EMPTY == this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Steps {
        public static Steps EMPTY = new Steps(Arrays.asList(new String[0]));
        private AfterScenario.Outcome outcome;
        private List<String> steps;

        public Steps(List<String> steps) {
            this(null, steps);
        }

        public Steps(AfterScenario.Outcome outcome, List<String> steps) {
            this.outcome = outcome;
            this.steps = steps;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

