/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jbehave.core.io.CodeLocations;
import org.jbehave.core.io.JarFileScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryFinder {
    private static final String JAR = ".jar";
    private static final String JAVA = ".java";
    private final String classNameExtension;
    private final Comparator<? super String> sortingComparator;

    public StoryFinder() {
        this(JAVA);
    }

    public StoryFinder(String classNameExtension) {
        this(classNameExtension, null);
    }

    public StoryFinder(Comparator<? super String> sortingComparator) {
        this(JAVA, sortingComparator);
    }

    private StoryFinder(String classNameExtension, Comparator<? super String> sortingComparator) {
        this.classNameExtension = classNameExtension;
        this.sortingComparator = sortingComparator;
    }

    public List<String> findClassNames(String searchIn, List<String> includes, List<String> excludes) {
        return this.classNames(this.normalise(this.sort(this.scan(searchIn, includes, excludes))));
    }

    public List<String> findPaths(URL searchIn, String include, String exclude) {
        return this.findPaths(CodeLocations.getPathFromURL(searchIn), this.asCSVList(include), this.asCSVList(exclude));
    }

    public List<String> findPaths(URL searchIn, String[] includes, String[] excludes) {
        return this.findPaths(CodeLocations.getPathFromURL(searchIn), Arrays.asList(includes), Arrays.asList(excludes));
    }

    public List<String> findPaths(String searchIn, String include, String exclude) {
        return this.findPaths(searchIn, this.asCSVList(include), this.asCSVList(exclude));
    }

    public List<String> findPaths(String searchIn, String[] includes, String[] excludes) {
        return this.findPaths(searchIn, Arrays.asList(includes), Arrays.asList(excludes));
    }

    public List<String> findPaths(URL searchIn, List<String> includes, List<String> excludes) {
        return this.findPaths(CodeLocations.getPathFromURL(searchIn), includes, excludes);
    }

    public List<String> findPaths(String searchIn, List<String> includes, List<String> excludes) {
        return this.normalise(this.sort(this.scan(searchIn, includes, excludes)));
    }

    public List<String> findPaths(String searchIn, List<String> includes, List<String> excludes, String prefixWith) {
        return this.normalise(this.prefix(prefixWith, this.sort(this.scan(searchIn, includes, excludes))));
    }

    protected List<String> normalise(List<String> paths) {
        ArrayList<String> transformed = new ArrayList<String>(paths);
        CollectionUtils.transform(transformed, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String path = (String)input;
                return path.replace('\\', '/');
            }
        });
        return transformed;
    }

    protected List<String> prefix(final String prefixWith, List<String> paths) {
        if (StringUtils.isBlank((String)prefixWith)) {
            return paths;
        }
        ArrayList<String> transformed = new ArrayList<String>(paths);
        CollectionUtils.transform(transformed, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String path = (String)input;
                return prefixWith + path;
            }
        });
        return transformed;
    }

    protected List<String> classNames(List<String> paths) {
        ArrayList<String> trasformed = new ArrayList<String>(paths);
        CollectionUtils.transform(trasformed, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String path = (String)input;
                if (!StringUtils.endsWithIgnoreCase((String)path, (String)StoryFinder.this.classNameExtension())) {
                    return input;
                }
                return StringUtils.removeEndIgnoreCase((String)path, (String)StoryFinder.this.classNameExtension()).replace('/', '.');
            }
        });
        return trasformed;
    }

    protected String classNameExtension() {
        return this.classNameExtension;
    }

    protected List<String> sort(List<String> input) {
        ArrayList<String> sorted = new ArrayList<String>(input);
        Collections.sort(sorted, this.sortingComparator());
        return sorted;
    }

    protected Comparator<? super String> sortingComparator() {
        return this.sortingComparator;
    }

    protected List<String> scan(String source, List<String> includes, List<String> excludes) {
        if (source.endsWith(JAR)) {
            return this.scanJar(source, includes, excludes);
        }
        return this.scanDirectory(source, includes, excludes);
    }

    private List<String> asCSVList(String pattern) {
        List<Object> list = pattern == null ? Arrays.asList(new Object[0]) : Arrays.asList(pattern.split(","));
        return list;
    }

    private List<String> scanDirectory(String basedir, List<String> includes, List<String> excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        if (!new File(basedir).exists()) {
            return new ArrayList<String>();
        }
        scanner.setBasedir(basedir);
        if (includes != null) {
            scanner.setIncludes(includes.toArray(new String[includes.size()]));
        }
        if (excludes != null) {
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles());
    }

    protected List<String> scanJar(String jarPath, List<String> includes, List<String> excludes) {
        return new JarFileScanner(jarPath, includes, excludes).scan();
    }
}

