/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.Map;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Parameters;
import org.jbehave.core.steps.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertedParameters
implements Parameters {
    private final Map<String, String> values;
    private final ParameterConverters parameterConverters;

    public ConvertedParameters(Row row, ParameterConverters parameterConverters) {
        this(row.values(), parameterConverters);
    }

    public ConvertedParameters(Map<String, String> values, ParameterConverters parameterConverters) {
        this.values = values;
        this.parameterConverters = parameterConverters;
    }

    @Override
    public <T> T valueAs(String name, Class<T> type) {
        return this.convert(this.valueFor(name), type);
    }

    @Override
    public <T> T valueAs(String name, Class<T> type, T defaultValue) {
        if (this.values.containsKey(name)) {
            return this.valueAs(name, type);
        }
        return defaultValue;
    }

    private <T> T convert(String value, Class<T> type) {
        return type.cast(this.parameterConverters.convert(value, type));
    }

    private String valueFor(String name) {
        if (!this.values.containsKey(name)) {
            throw new ValueNotFound(name);
        }
        return this.values.get(name);
    }

    @Override
    public Map<String, String> values() {
        return this.values;
    }

    public static class ValueNotFound
    extends RuntimeException {
        public ValueNotFound(String name) {
            super(name);
        }
    }
}

