/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.junit;

import org.jbehave.core.embedder.EmbedderClassLoader;
import org.jbehave.core.junit.AnnotatedEmbedderRunner;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedEmbedderUtils {
    public static AnnotatedEmbedderRunner annotatedEmbedderRunner(String annotatedClassName, EmbedderClassLoader classLoader) {
        Class<?> runnerClass = AnnotatedEmbedderUtils.runnerClass(annotatedClassName, classLoader);
        return AnnotatedEmbedderUtils.newAnnotatedEmbedderRunner(runnerClass, annotatedClassName, classLoader);
    }

    private static Class<?> runnerClass(String annotatedClassName, EmbedderClassLoader classLoader) {
        Class<?> annotatedClass = AnnotatedEmbedderUtils.loadClass(annotatedClassName, classLoader);
        RunWith annotation = annotatedClass.getAnnotation(RunWith.class);
        if (annotation != null) {
            return annotation.value();
        }
        throw new MissingAnnotatedEmbedderRunner(annotatedClass);
    }

    private static AnnotatedEmbedderRunner newAnnotatedEmbedderRunner(Class<?> runnerClass, String annotatedClassName, EmbedderClassLoader classLoader) {
        try {
            Class<?> annotatedClass = AnnotatedEmbedderUtils.loadClass(annotatedClassName, classLoader);
            return (AnnotatedEmbedderRunner)((Object)runnerClass.getConstructor(Class.class).newInstance(annotatedClass));
        }
        catch (Exception e) {
            throw new AnnotatedEmbedderRunnerInstantiationFailed(runnerClass, annotatedClassName, classLoader, e);
        }
    }

    private static Class<?> loadClass(String className, EmbedderClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ClassLoadingFailed(className, classLoader, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MissingAnnotatedEmbedderRunner
    extends RuntimeException {
        public MissingAnnotatedEmbedderRunner(Class<?> annotatedClass) {
            super("AnnotatedEmbedderRunner not specified via @RunWith annotation in annotatedClass " + annotatedClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedEmbedderRunnerInstantiationFailed
    extends RuntimeException {
        public AnnotatedEmbedderRunnerInstantiationFailed(Class<?> runnerClass, String annotatedClassName, EmbedderClassLoader classLoader, Throwable cause) {
            super("Failed to instantiate annotated embedder runner " + runnerClass + " with annotatedClassName " + annotatedClassName + " and classLoader " + classLoader, cause);
        }
    }

    public static class ClassLoadingFailed
    extends RuntimeException {
        public ClassLoadingFailed(String className, EmbedderClassLoader classLoader, Throwable cause) {
            super("Failed to load class " + className + " with classLoader " + classLoader, cause);
        }
    }
}

