/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeLocations {
    public static URL codeLocationFromClass(Class<?> codeLocationClass) {
        String pathOfClass = codeLocationClass.getName().replace(".", "/") + ".class";
        URL classResource = codeLocationClass.getClassLoader().getResource(pathOfClass);
        String codeLocationPath = StringUtils.removeEnd((String)CodeLocations.getPathFromURL(classResource), (String)pathOfClass);
        if (codeLocationPath.endsWith(".jar!/")) {
            codeLocationPath = StringUtils.removeEnd((String)codeLocationPath, (String)"!/");
        }
        return CodeLocations.codeLocationFromPath(codeLocationPath);
    }

    public static URL codeLocationFromPath(String filePath) {
        try {
            return new File(filePath).toURI().toURL();
        }
        catch (Exception e) {
            throw new InvalidCodeLocation(filePath);
        }
    }

    public static URL codeLocationFromURL(String url) {
        try {
            return new URL(url);
        }
        catch (Exception e) {
            throw new InvalidCodeLocation(url);
        }
    }

    public static String getPathFromURL(URL url) {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new InvalidCodeLocation(e.toString());
        }
        if (uri.toString().startsWith("file:") || uri.toString().startsWith("jar:")) {
            return StringUtils.removeStart((String)uri.getSchemeSpecificPart(), (String)"file:");
        }
        return uri.toString();
    }

    public static class InvalidCodeLocation
    extends RuntimeException {
        public InvalidCodeLocation(String path) {
            super(path);
        }
    }
}

