/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.thoughtworks.paranamer.NullParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Named;
import org.jbehave.core.failures.BeforeOrAfterFailed;
import org.jbehave.core.failures.RestartingScenarioFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Meta;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepCreator {
    public static final String PARAMETER_NAME_START = "<";
    public static final String PARAMETER_NAME_END = ">";
    public static final String PARAMETER_TABLE_START = "\uff3b";
    public static final String PARAMETER_TABLE_END = "\uff3d";
    public static final String PARAMETER_VALUE_START = "\uff5f";
    public static final String PARAMETER_VALUE_END = "\uff60";
    public static final String PARAMETER_VALUE_NEWLINE = "\u2424";
    public static final UUIDExceptionWrapper NO_FAILURE = new UUIDExceptionWrapper("no failure");
    private final Class<?> stepsType;
    private final InjectableStepsFactory stepsFactory;
    private final ParameterConverters parameterConverters;
    private final StepMatcher stepMatcher;
    private StepMonitor stepMonitor;
    private Paranamer paranamer = new NullParanamer();
    private boolean dryRun = false;

    public StepCreator(Class<?> stepsType, InjectableStepsFactory stepsFactory, ParameterConverters parameterConverters, StepMatcher stepMatcher, StepMonitor stepMonitor) {
        this.stepsType = stepsType;
        this.stepsFactory = stepsFactory;
        this.parameterConverters = parameterConverters;
        this.stepMatcher = stepMatcher;
        this.stepMonitor = stepMonitor;
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
    }

    public void useParanamer(Paranamer paranamer) {
        this.paranamer = paranamer;
    }

    public void doDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Object stepsInstance() {
        return this.stepsFactory.createInstanceOfType(this.stepsType);
    }

    public Step createBeforeOrAfterStep(Method method, Meta meta) {
        return new BeforeOrAfterStep(method, meta);
    }

    public Step createAfterStepUponOutcome(Method method, AfterScenario.Outcome outcome, Meta storyAndScenarioMeta) {
        switch (outcome) {
            default: {
                return new BeforeOrAfterStep(method, storyAndScenarioMeta);
            }
            case SUCCESS: {
                return new SuccessStep(method, storyAndScenarioMeta);
            }
            case FAILURE: 
        }
        return new FailureStep(method, storyAndScenarioMeta);
    }

    public Map<String, String> matchedParameters(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters) {
        this.stepMatcher.find(stepWithoutStartingWord);
        String[] annotationNames = this.annotatedParameterNames(method);
        String[] parameterNames = this.paranamer.lookupParameterNames((AccessibleObject)method, false);
        Type[] types = method.getGenericParameterTypes();
        String[] names = annotationNames.length > 0 ? annotationNames : parameterNames;
        String[] values = this.parameterValuesForStep(namedParameters, types, annotationNames, parameterNames);
        HashMap<String, String> matchedParameters = new HashMap<String, String>();
        for (int i = 0; i < names.length; ++i) {
            matchedParameters.put(names[i], values[i]);
        }
        return matchedParameters;
    }

    public Step createParametrisedStep(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters) {
        return new ParameterisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
    }

    private String[] annotatedParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterAnnotations.length];
        for (int x = 0; x < parameterAnnotations.length; ++x) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[x]) {
                names[x] = this.annotationName(annotation);
            }
        }
        return names;
    }

    private String annotationName(Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(Named.class)) {
            return ((Named)annotation).value();
        }
        if ("javax.inject.Named".equals(annotation.annotationType().getName())) {
            return Jsr330Helper.getNamedValue(annotation);
        }
        return null;
    }

    private String parametrisedStep(String stepAsString, Map<String, String> namedParameters, Type[] types, String[] annotationNames, String[] parameterNames, String[] parameterValues) {
        String parametrisedStep = stepAsString;
        for (int position = 0; position < types.length; ++position) {
            parametrisedStep = this.replaceParameterValuesInStep(parametrisedStep, position, types, annotationNames, parameterNames, parameterValues, namedParameters);
        }
        return parametrisedStep;
    }

    private String replaceParameterValuesInStep(String stepText, int position, Type[] types, String[] annotationNames, String[] parameterNames, String[] parameterValues, Map<String, String> namedParameters) {
        int annotatedNamePosition = this.parameterPosition(annotationNames, position);
        int parameterNamePosition = this.parameterPosition(parameterNames, position);
        stepText = this.replaceParameterValue(stepText, types[position], parameterValues[position]);
        if (annotatedNamePosition != -1) {
            stepText = this.replaceParameterName(stepText, namedParameters, annotationNames[position]);
        } else if (parameterNamePosition != -1) {
            stepText = this.replaceParameterName(stepText, namedParameters, parameterNames[position]);
        }
        return stepText;
    }

    private String replaceParameterName(String stepText, Map<String, String> namedParameters, String name) {
        String value = this.namedParameter(namedParameters, name);
        if (value != null) {
            stepText = stepText.replace(PARAMETER_NAME_START + name + PARAMETER_NAME_END, PARAMETER_VALUE_START + value + PARAMETER_VALUE_END);
        }
        return stepText;
    }

    private String replaceParameterValue(String stepText, Type type, String value) {
        if (value != null) {
            if (this.isTable(type)) {
                stepText = stepText.replace(value, PARAMETER_TABLE_START + value + PARAMETER_TABLE_END);
            } else {
                if (!value.trim().isEmpty()) {
                    stepText = stepText.replace(value, PARAMETER_VALUE_START + value + PARAMETER_VALUE_END);
                }
                stepText = stepText.replace("\n", PARAMETER_VALUE_NEWLINE);
            }
        }
        return stepText;
    }

    private boolean isTable(Type type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(ExamplesTable.class);
    }

    private String[] parameterValuesForStep(Map<String, String> namedParameters, Type[] types, String[] annotationNames, String[] parameterNames) {
        String[] parameters = new String[types.length];
        for (int position = 0; position < types.length; ++position) {
            parameters[position] = this.parameterForPosition(position, annotationNames, parameterNames, namedParameters);
        }
        return parameters;
    }

    private Object[] convertParameterValues(String[] valuesAsString, Type[] types) {
        Object[] parameters = new Object[valuesAsString.length];
        for (int position = 0; position < valuesAsString.length; ++position) {
            parameters[position] = this.parameterConverters.convert(valuesAsString[position], types[position]);
        }
        return parameters;
    }

    private String parameterForPosition(int position, String[] annotationNames, String[] parameterNames, Map<String, String> namedParameters) {
        int annotatedNamePosition = this.parameterPosition(annotationNames, position);
        int parameterNamePosition = this.parameterPosition(parameterNames, position);
        String parameter = null;
        if (annotatedNamePosition != -1 && this.isGroupName(annotationNames[position])) {
            String name = annotationNames[position];
            this.stepMonitor.usingAnnotatedNameForParameter(name, position);
            parameter = this.matchedParameter(name);
        } else if (parameterNamePosition != -1 && this.isGroupName(parameterNames[position])) {
            String name = parameterNames[position];
            this.stepMonitor.usingParameterNameForParameter(name, position);
            parameter = this.matchedParameter(name);
        } else if (annotatedNamePosition != -1 && this.isTableName(namedParameters, annotationNames[position])) {
            String name = annotationNames[position];
            this.stepMonitor.usingTableAnnotatedNameForParameter(name, position);
            parameter = this.namedParameter(namedParameters, name);
        } else if (parameterNamePosition != -1 && this.isTableName(namedParameters, parameterNames[position])) {
            String name = parameterNames[position];
            this.stepMonitor.usingTableParameterNameForParameter(name, position);
            parameter = this.namedParameter(namedParameters, name);
        } else {
            this.stepMonitor.usingNaturalOrderForParameter(position);
            parameter = this.matchedParameter(position);
        }
        this.stepMonitor.foundParameter(parameter, position);
        return parameter;
    }

    String matchedParameter(String name) {
        String[] parameterNames = this.stepMatcher.parameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            if (!name.equals(parameterName)) continue;
            return this.matchedParameter(i);
        }
        throw new ParameterNotFound(name, parameterNames);
    }

    private String matchedParameter(int position) {
        int matchedPosition = position + 1;
        String[] parameterNames = this.stepMatcher.parameterNames();
        if (matchedPosition <= parameterNames.length) {
            return this.stepMatcher.parameter(matchedPosition);
        }
        throw new ParameterNotFound(position, parameterNames);
    }

    private int parameterPosition(String[] names, int position) {
        if (names.length == 0) {
            return -1;
        }
        String positionName = names[position];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null || !positionName.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private boolean isGroupName(String name) {
        String[] groupNames;
        for (String groupName : groupNames = this.stepMatcher.parameterNames()) {
            if (!name.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    private String namedParameter(Map<String, String> namedParameters, String name) {
        return namedParameters.get(name);
    }

    private boolean isTableName(Map<String, String> namedParameters, String name) {
        return this.namedParameter(namedParameters, name) != null;
    }

    public static Step createPendingStep(String stepAsString, String previousNonAndStep) {
        return new PendingStep(stepAsString, previousNonAndStep);
    }

    public static Step createIgnorableStep(String stepAsString) {
        return new IgnorableStep(stepAsString);
    }

    private class MethodInvoker {
        private final Method method;
        private final ParameterConverters parameterConverters;
        private final Paranamer paranamer;
        private final Meta meta;
        private int methodArity;

        public MethodInvoker(Method method, ParameterConverters parameterConverters, Paranamer paranamer, Meta meta) {
            this.method = method;
            this.parameterConverters = parameterConverters;
            this.paranamer = paranamer;
            this.meta = meta;
            this.methodArity = method.getParameterTypes().length;
        }

        public void invoke() throws InvocationTargetException, IllegalAccessException {
            this.method.invoke(StepCreator.this.stepsInstance(), this.parameterValuesFrom(this.meta));
        }

        private Parameter[] methodParameters() {
            Parameter[] parameters = new Parameter[this.methodArity];
            String[] annotationNamedParameters = StepCreator.this.annotatedParameterNames(this.method);
            String[] parameterNames = this.paranamer.lookupParameterNames((AccessibleObject)this.method, false);
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int paramPosition = 0; paramPosition < this.methodArity; ++paramPosition) {
                String paramName = this.parameterNameFor(paramPosition, annotationNamedParameters, parameterNames);
                parameters[paramPosition] = new Parameter(paramPosition, parameterTypes[paramPosition], paramName);
            }
            return parameters;
        }

        private String parameterNameFor(int paramPosition, String[] annotationNamedParameters, String[] parameterNames) {
            String nameFromAnnotation = this.nameIfValidPositionInArray(annotationNamedParameters, paramPosition);
            String parameterName = this.nameIfValidPositionInArray(parameterNames, paramPosition);
            if (nameFromAnnotation != null) {
                return nameFromAnnotation;
            }
            if (parameterName != null) {
                return parameterName;
            }
            return null;
        }

        private String nameIfValidPositionInArray(String[] paramNames, int paramPosition) {
            return paramPosition < paramNames.length ? paramNames[paramPosition] : null;
        }

        private Object[] parameterValuesFrom(Meta meta) {
            Object[] values = new Object[this.methodArity];
            for (Parameter parameter : this.methodParameters()) {
                values[((Parameter)parameter).position] = this.parameterConverters.convert(parameter.valueFrom(meta), parameter.type);
            }
            return values;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Parameter {
            private final int position;
            private final Class<?> type;
            private final String name;

            public Parameter(int position, Class<?> type, String name) {
                this.position = position;
                this.type = type;
                this.name = name;
            }

            public String valueFrom(Meta meta) {
                if (this.name == null) {
                    return null;
                }
                return meta.getProperty(this.name);
            }
        }
    }

    public static class IgnorableStep
    extends AbstractStep {
        private final String stepAsString;

        public IgnorableStep(String stepAsString) {
            this.stepAsString = stepAsString;
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.ignorable(this.stepAsString);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.ignorable(this.stepAsString);
        }
    }

    public static class PendingStep
    extends AbstractStep {
        private final String stepAsString;
        private final String previousNonAndStep;
        private Method method;

        public PendingStep(String stepAsString, String previousNonAndStep) {
            this.stepAsString = stepAsString;
            this.previousNonAndStep = previousNonAndStep;
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.pending(this.stepAsString);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.pending(this.stepAsString);
        }

        public String stepAsString() {
            return this.stepAsString;
        }

        public String previousNonAndStepAsString() {
            return this.previousNonAndStep;
        }

        public void annotatedOn(Method method) {
            this.method = method;
        }

        public boolean annotated() {
            return this.method != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ParameterisedStep
    extends AbstractStep {
        private Object[] convertedParameters;
        private String parametrisedStep;
        private final String stepAsString;
        private final Method method;
        private final String stepWithoutStartingWord;
        private final Map<String, String> namedParameters;

        public ParameterisedStep(String stepAsString, Method method, String stepWithoutStartingWord, Map<String, String> namedParameters) {
            this.stepAsString = stepAsString;
            this.method = method;
            this.stepWithoutStartingWord = stepWithoutStartingWord;
            this.namedParameters = namedParameters;
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            try {
                this.parametriseStep();
                StepCreator.this.stepMonitor.performing(this.stepAsString, StepCreator.this.dryRun);
                if (!StepCreator.this.dryRun) {
                    this.method.invoke(StepCreator.this.stepsInstance(), this.convertedParameters);
                }
                return AbstractStepResult.successful(this.stepAsString).withParameterValues(this.parametrisedStep);
            }
            catch (ParameterNotFound e) {
                return AbstractStepResult.pending(this.stepAsString).withParameterValues(this.parametrisedStep);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RestartingScenarioFailure) {
                    throw (RestartingScenarioFailure)e.getCause();
                }
                Throwable failureCause = e.getCause();
                if (failureCause instanceof UUIDExceptionWrapper) {
                    failureCause = failureCause.getCause();
                }
                return AbstractStepResult.failed(this.stepAsString, new UUIDExceptionWrapper(this.stepAsString, failureCause)).withParameterValues(this.parametrisedStep);
            }
            catch (Throwable t) {
                return AbstractStepResult.failed(this.stepAsString, new UUIDExceptionWrapper(this.stepAsString, t)).withParameterValues(this.parametrisedStep);
            }
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            try {
                this.parametriseStep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return AbstractStepResult.notPerformed(this.stepAsString).withParameterValues(this.parametrisedStep);
        }

        private void parametriseStep() {
            StepCreator.this.stepMatcher.find(this.stepWithoutStartingWord);
            String[] annotationNames = StepCreator.this.annotatedParameterNames(this.method);
            String[] parameterNames = StepCreator.this.paranamer.lookupParameterNames((AccessibleObject)this.method, false);
            Type[] types = this.method.getGenericParameterTypes();
            String[] parameterValues = StepCreator.this.parameterValuesForStep(this.namedParameters, types, annotationNames, parameterNames);
            this.convertedParameters = StepCreator.this.convertParameterValues(parameterValues, types);
            this.addNamedParametersToExamplesTables();
            this.parametrisedStep = StepCreator.this.parametrisedStep(this.stepAsString, this.namedParameters, types, annotationNames, parameterNames, parameterValues);
        }

        private void addNamedParametersToExamplesTables() {
            for (Object object : this.convertedParameters) {
                if (!(object instanceof ExamplesTable)) continue;
                ((ExamplesTable)object).withNamedParameters(this.namedParameters);
            }
        }
    }

    public class FailureStep
    extends AbstractStep {
        private final BeforeOrAfterStep beforeOrAfterStep;

        public FailureStep(Method method, Meta storyAndScenarioMeta) {
            this.beforeOrAfterStep = new BeforeOrAfterStep(method, storyAndScenarioMeta);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.beforeOrAfterStep.perform(storyFailureIfItHappened);
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }
    }

    public class SuccessStep
    extends AbstractStep {
        private BeforeOrAfterStep beforeOrAfterStep;

        public SuccessStep(Method method, Meta storyAndScenarioMeta) {
            this.beforeOrAfterStep = new BeforeOrAfterStep(method, storyAndScenarioMeta);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.beforeOrAfterStep.perform(storyFailureIfItHappened);
        }
    }

    private class BeforeOrAfterStep
    extends AbstractStep {
        private final Method method;
        private final Meta meta;

        public BeforeOrAfterStep(Method method, Meta meta) {
            this.method = method;
            this.meta = meta;
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            ParameterConverters paramConvertersWithExceptionInjector = this.paramConvertersWithExceptionInjector(storyFailureIfItHappened);
            MethodInvoker methodInvoker = new MethodInvoker(this.method, paramConvertersWithExceptionInjector, StepCreator.this.paranamer, this.meta);
            try {
                methodInvoker.invoke();
            }
            catch (InvocationTargetException e) {
                return AbstractStepResult.failed(this.method, new UUIDExceptionWrapper(new BeforeOrAfterFailed(this.method, e.getCause())));
            }
            catch (Throwable t) {
                return AbstractStepResult.failed(this.method, new UUIDExceptionWrapper(new BeforeOrAfterFailed(this.method, t)));
            }
            return AbstractStepResult.skipped();
        }

        private ParameterConverters paramConvertersWithExceptionInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
            return StepCreator.this.parameterConverters.newInstanceAdding(new UUIDExceptionWrapperInjector(storyFailureIfItHappened));
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyFailureIfItHappened);
        }

        private class UUIDExceptionWrapperInjector
        implements ParameterConverters.ParameterConverter {
            private final UUIDExceptionWrapper storyFailureIfItHappened;

            public UUIDExceptionWrapperInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
                this.storyFailureIfItHappened = storyFailureIfItHappened;
            }

            public boolean accept(Type type) {
                return UUIDExceptionWrapper.class == type;
            }

            public Object convertValue(String value, Type type) {
                return this.storyFailureIfItHappened;
            }
        }
    }

    public static abstract class AbstractStep
    implements Step {
        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }

    public static class ParameterNotFound
    extends RuntimeException {
        public ParameterNotFound(String name, String[] parameters) {
            super("Parameter not found for name '" + name + "' amongst '" + Arrays.asList(parameters) + "'");
        }

        public ParameterNotFound(int position, String[] parameters) {
            super("Parameter not found for position '" + position + "' amongst '" + Arrays.asList(parameters) + "'");
        }
    }

    public static class Jsr330Helper {
        private static String getNamedValue(Annotation annotation) {
            return ((javax.inject.Named)annotation).value();
        }
    }
}

