/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeLocations {
    public static URL codeLocationFromClass(Class<?> codeLocationClass) {
        String pathOfClass = codeLocationClass.getName().replace(".", "/") + ".class";
        URL classResource = codeLocationClass.getClassLoader().getResource(pathOfClass);
        String codeLocationPath = StringUtils.removeEnd((String)classResource.getFile(), (String)pathOfClass);
        return CodeLocations.codeLocationFromPath(codeLocationPath);
    }

    public static URL codeLocationFromPath(String filePath) {
        try {
            return new File(filePath).toURI().toURL();
        }
        catch (Exception e) {
            throw new InvalidCodeLocation(filePath);
        }
    }

    public static URL codeLocationFromURL(String url) {
        try {
            return new URL(url);
        }
        catch (Exception e) {
            throw new InvalidCodeLocation(url);
        }
    }

    public static class InvalidCodeLocation
    extends RuntimeException {
        public InvalidCodeLocation(String path) {
            super(path);
        }
    }
}

