/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jbehave.core.annotations.Pending;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepCandidate {
    private final String patternAsString;
    private final Integer priority;
    private final StepType stepType;
    private final Method method;
    private final Object stepsInstance;
    private final Keywords keywords;
    private final StepMatcher stepMatcher;
    private final StepCreator stepCreator;
    private StepMonitor stepMonitor = new SilentStepMonitor();
    private String[] composedSteps;

    public StepCandidate(String patternAsString, int priority, StepType stepType, Method method, Object stepsInstance, Keywords keywords, StepPatternParser stepPatternParser, ParameterConverters parameterConverters) {
        this.patternAsString = patternAsString;
        this.priority = priority;
        this.stepType = stepType;
        this.method = method;
        this.stepsInstance = stepsInstance;
        this.keywords = keywords;
        this.stepMatcher = stepPatternParser.parseStep(stepType, patternAsString);
        this.stepCreator = new StepCreator(stepsInstance, parameterConverters, this.stepMatcher, this.stepMonitor);
    }

    public Method getMethod() {
        return this.method;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getPatternAsString() {
        return this.patternAsString;
    }

    public Object getStepsInstance() {
        return this.stepsInstance;
    }

    public StepType getStepType() {
        return this.stepType;
    }

    public String getStartingWord() {
        return this.keywords.startingWordFor(this.stepType);
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        this.stepCreator.useStepMonitor(stepMonitor);
    }

    public void doDryRun(boolean dryRun) {
        this.stepCreator.doDryRun(dryRun);
    }

    public void useParanamer(Paranamer paranamer) {
        this.stepCreator.useParanamer(paranamer);
    }

    public void composedOf(String[] steps) {
        this.composedSteps = steps;
    }

    public boolean isComposite() {
        return this.composedSteps != null && this.composedSteps.length > 0;
    }

    public boolean ignore(String stepAsString) {
        try {
            String ignoreWord = this.keywords.startingWordFor(StepType.IGNORABLE);
            return this.keywords.stepStartsWithWord(stepAsString, ignoreWord);
        }
        catch (Keywords.StartingWordNotFound e) {
            return false;
        }
    }

    public boolean isPending() {
        return this.method.isAnnotationPresent(Pending.class);
    }

    public boolean matches(String stepAsString) {
        return this.matches(stepAsString, null);
    }

    public boolean matches(String step, String previousNonAndStep) {
        try {
            boolean matchesType = true;
            if (this.isAndStep(step)) {
                matchesType = previousNonAndStep == null ? false : this.keywords.startingWordFor(this.stepType).equals(this.findStartingWord(previousNonAndStep));
            }
            this.stepMonitor.stepMatchesType(step, previousNonAndStep, matchesType, this.stepType, this.method, this.stepsInstance);
            boolean matchesPattern = this.stepMatcher.matches(this.stripStartingWord(step));
            this.stepMonitor.stepMatchesPattern(step, matchesPattern, this.stepMatcher.pattern(), this.method, this.stepsInstance);
            return matchesType && matchesPattern;
        }
        catch (Keywords.StartingWordNotFound e) {
            return false;
        }
    }

    public Step createMatchedStep(String stepAsString, Map<String, String> namedParameters) {
        return this.stepCreator.createParametrisedStep(this.method, stepAsString, this.stripStartingWord(stepAsString), namedParameters);
    }

    public List<Step> createComposedSteps(String stepAsString, Map<String, String> namedParameters, List<StepCandidate> allCandidates) {
        Map<String, String> matchedParameters = namedParameters.isEmpty() ? this.stepCreator.matchedParameters(this.method, stepAsString, this.stripStartingWord(stepAsString), namedParameters) : namedParameters;
        ArrayList<Step> steps = new ArrayList<Step>();
        for (String composedStep : this.composedSteps) {
            StepCandidate candidate = this.findComposedCandidate(composedStep, allCandidates);
            if (candidate == null) continue;
            steps.add(candidate.createMatchedStep(composedStep, matchedParameters));
        }
        return steps;
    }

    private StepCandidate findComposedCandidate(String composedStep, List<StepCandidate> allCandidates) {
        for (StepCandidate candidate : allCandidates) {
            if (!StringUtils.startsWith((String)composedStep, (String)candidate.getStartingWord()) || !StringUtils.endsWith((String)composedStep, (String)candidate.getPatternAsString())) continue;
            return candidate;
        }
        return null;
    }

    public boolean isAndStep(String stepAsString) {
        return this.keywords.isAndStep(stepAsString);
    }

    private String findStartingWord(String stepAsString) {
        return this.keywords.startingWord(stepAsString, this.stepType);
    }

    private String stripStartingWord(String stepAsString) {
        return this.keywords.stepWithoutStartingWord(stepAsString, this.stepType);
    }

    public String toString() {
        return (Object)((Object)this.stepType) + " " + this.patternAsString;
    }
}

