/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingStoryReporter
implements StoryReporter {
    private final Collection<StoryReporter> delegates;

    public DelegatingStoryReporter(Collection<StoryReporter> delegates) {
        this.delegates = delegates;
    }

    public DelegatingStoryReporter(StoryReporter ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public void afterScenario() {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterScenario();
        }
    }

    @Override
    public void afterStory(boolean givenStory) {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterStory(givenStory);
        }
    }

    @Override
    public void beforeScenario(String scenarioTitle) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeScenario(scenarioTitle);
        }
    }

    @Override
    public void scenarioMeta(Meta meta) {
        for (StoryReporter reporter : this.delegates) {
            reporter.scenarioMeta(meta);
        }
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeStory(story, givenStory);
        }
    }

    @Override
    public void narrative(Narrative narrative) {
        for (StoryReporter reporter : this.delegates) {
            reporter.narrative(narrative);
        }
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeExamples(steps, table);
        }
    }

    @Override
    public void example(Map<String, String> tableRow) {
        for (StoryReporter reporter : this.delegates) {
            reporter.example(tableRow);
        }
    }

    @Override
    public void afterExamples() {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterExamples();
        }
    }

    @Override
    public void failed(String step, Throwable cause) {
        for (StoryReporter reporter : this.delegates) {
            reporter.failed(step, cause);
        }
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        for (StoryReporter reporter : this.delegates) {
            reporter.failedOutcomes(step, table);
        }
    }

    @Override
    public void givenStories(GivenStories givenStories) {
        for (StoryReporter reporter : this.delegates) {
            reporter.givenStories(givenStories);
        }
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        for (StoryReporter reporter : this.delegates) {
            reporter.givenStories(storyPaths);
        }
    }

    @Override
    public void ignorable(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.ignorable(step);
        }
    }

    @Override
    public void notPerformed(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.notPerformed(step);
        }
    }

    @Override
    public void pending(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.pending(step);
        }
    }

    @Override
    public void successful(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.successful(step);
        }
    }

    @Override
    public void scenarioNotAllowed(Scenario scenario, String filter) {
        for (StoryReporter reporter : this.delegates) {
            reporter.scenarioNotAllowed(scenario, filter);
        }
    }

    @Override
    public void storyNotAllowed(Story story, String filter) {
        for (StoryReporter reporter : this.delegates) {
            reporter.storyNotAllowed(story, filter);
        }
    }

    @Override
    public void dryRun() {
        for (StoryReporter reporter : this.delegates) {
            reporter.dryRun();
        }
    }

    @Override
    public void pendingMethods(List<String> methods) {
        for (StoryReporter reporter : this.delegates) {
            reporter.pendingMethods(methods);
        }
    }

    public Collection<StoryReporter> getDelegates() {
        return this.delegates;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

