/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Story {
    private final String path;
    private final Description description;
    private final Meta meta;
    private final Narrative narrative;
    private final List<Scenario> scenarios;
    private String name;

    public Story() {
        this(Arrays.asList(new Scenario[0]));
    }

    public Story(String path) {
        this(path, Description.EMPTY, Narrative.EMPTY, Arrays.asList(new Scenario[0]));
    }

    public Story(List<Scenario> scenarios) {
        this(Description.EMPTY, Narrative.EMPTY, scenarios);
    }

    public Story(Description description, Narrative narrative, List<Scenario> scenarios) {
        this(null, description, narrative, scenarios);
    }

    public Story(String path, Description description, Narrative narrative, List<Scenario> scenarios) {
        this(path, description, Meta.EMPTY, narrative, scenarios);
    }

    public Story(String path, Description description, Meta meta, Narrative narrative, List<Scenario> scenarios) {
        this.path = path;
        this.description = description;
        this.meta = meta;
        this.narrative = narrative;
        this.scenarios = scenarios;
    }

    public Description getDescription() {
        return this.description;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Narrative getNarrative() {
        return this.narrative;
    }

    public List<Scenario> getScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    public String getName() {
        return this.name != null ? this.name : this.getPath();
    }

    public void namedAs(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path != null ? this.path : "";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

