/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.FilteredStory;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.StoryRunner;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryManager {
    private final Configuration configuration;
    private final EmbedderControls embedderControls;
    private final EmbedderMonitor embedderMonitor;
    private final ExecutorService executorService;
    private final InjectableStepsFactory stepsFactory;
    private final StoryRunner storyRunner;
    private final Map<String, RunningStory> runningStories = new HashMap<String, RunningStory>();
    private final Map<MetaFilter, List<Story>> excludedStories = new HashMap<MetaFilter, List<Story>>();

    public StoryManager(Configuration configuration, EmbedderControls embedderControls, EmbedderMonitor embedderMonitor, ExecutorService executorService, InjectableStepsFactory stepsFactory, StoryRunner storyRunner) {
        this.configuration = configuration;
        this.embedderControls = embedderControls;
        this.embedderMonitor = embedderMonitor;
        this.executorService = executorService;
        this.stepsFactory = stepsFactory;
        this.storyRunner = storyRunner;
    }

    public Story storyOfPath(String storyPath) {
        return this.storyRunner.storyOfPath(this.configuration, storyPath);
    }

    public Story storyOfText(String storyAsText, String storyId) {
        return this.storyRunner.storyOfText(this.configuration, storyAsText, storyId);
    }

    public void clear() {
        this.runningStories.clear();
    }

    public List<StoryOutcome> outcomes() {
        ArrayList<StoryOutcome> outcomes = new ArrayList<StoryOutcome>();
        for (RunningStory story : this.runningStories.values()) {
            outcomes.add(new StoryOutcome(story));
        }
        return outcomes;
    }

    public void runStories(List<String> storyPaths, MetaFilter filter, BatchFailures failures) {
        if (this.configuration.storyReporterBuilder().hasCrossReference()) {
            this.configuration.storyReporterBuilder().crossReference().withMetaFilter(filter.asString());
        }
        StoryRunner.State beforeStories = this.runBeforeOrAfterStories(failures, StepCollector.Stage.BEFORE);
        this.runningStoriesAsPaths(storyPaths, filter, beforeStories);
        this.waitUntilAllDoneOrFailed(failures);
        List<Story> notAllowed = this.notAllowedBy(filter);
        if (!notAllowed.isEmpty()) {
            this.embedderMonitor.storiesNotAllowed(notAllowed, filter, this.embedderControls.verboseFiltering());
        }
        this.runBeforeOrAfterStories(failures, StepCollector.Stage.AFTER);
    }

    public StoryRunner.State runBeforeOrAfterStories(BatchFailures failures, StepCollector.Stage stage) {
        List<CandidateSteps> candidateSteps = this.stepsFactory.createCandidateSteps();
        StoryRunner.State state = this.storyRunner.runBeforeOrAfterStories(this.configuration, candidateSteps, stage);
        if (this.storyRunner.failed(state)) {
            failures.put(state.toString(), this.storyRunner.failure(state));
        }
        return state;
    }

    public Map<String, RunningStory> runningStoriesAsPaths(List<String> storyPaths, MetaFilter filter, StoryRunner.State beforeStories) {
        for (String storyPath : storyPaths) {
            this.filterRunning(filter, beforeStories, storyPath, this.storyOfPath(storyPath));
        }
        return this.runningStories;
    }

    public Map<String, RunningStory> runningStories(List<Story> stories, MetaFilter filter, StoryRunner.State beforeStories) {
        for (Story story : stories) {
            this.filterRunning(filter, beforeStories, story.getPath(), story);
        }
        return this.runningStories;
    }

    private void filterRunning(MetaFilter filter, StoryRunner.State beforeStories, String storyPath, Story story) {
        FilteredStory filteredStory = new FilteredStory(filter, story, this.configuration.storyControls());
        if (filteredStory.allowed()) {
            this.runningStories.put(storyPath, this.runningStory(storyPath, story, filter, beforeStories));
        } else {
            this.notAllowedBy(filter).add(story);
        }
    }

    public List<Story> notAllowedBy(MetaFilter filter) {
        List<Story> stories = this.excludedStories.get(filter);
        if (stories == null) {
            stories = new ArrayList<Story>();
            this.excludedStories.put(filter, stories);
        }
        return stories;
    }

    public RunningStory runningStory(String storyPath, Story story, MetaFilter filter, StoryRunner.State beforeStories) {
        return this.submit(new EnqueuedStory(this.storyRunner, this.configuration, this.stepsFactory, this.embedderControls, this.embedderMonitor, storyPath, story, filter, beforeStories));
    }

    public void waitUntilAllDoneOrFailed(BatchFailures failures) {
        if (this.runningStories.values().isEmpty()) {
            return;
        }
        boolean allDone = false;
        boolean started = false;
        while (!allDone || !started) {
            allDone = true;
            for (RunningStory runningStory : this.runningStories.values()) {
                if (runningStory.isStarted()) {
                    started = true;
                    Story story = runningStory.getStory();
                    Future<ThrowableStory> future = runningStory.getFuture();
                    if (!future.isDone()) {
                        allDone = false;
                        StoryDuration duration = runningStory.getDuration();
                        runningStory.updateDuration();
                        if (!duration.timedOut()) continue;
                        this.embedderMonitor.storyTimeout(story, duration);
                        this.storyRunner.cancelStory(story, duration);
                        future.cancel(true);
                        if (!this.embedderControls.failOnStoryTimeout()) continue;
                        throw new StoryExecutionFailed(story.getPath(), new StoryTimeout(duration));
                    }
                    try {
                        ThrowableStory throwableStory = (ThrowableStory)future.get();
                        Throwable throwable = throwableStory.getThrowable();
                        if (throwable == null) continue;
                        failures.put(story.getPath(), throwable);
                        if (this.embedderControls.ignoreFailureInStories()) continue;
                    }
                    catch (Throwable e) {
                        failures.put(story.getPath(), e);
                        if (this.embedderControls.ignoreFailureInStories()) continue;
                    }
                    continue;
                }
                started = false;
            }
            this.tickTock();
        }
        Properties storyDurations = new Properties();
        long total = 0L;
        for (RunningStory runningStory : this.runningStories.values()) {
            long durationInMillis = runningStory.getDurationInMillis();
            total += durationInMillis;
            storyDurations.setProperty(runningStory.getStory().getPath(), Long.toString(durationInMillis));
            Future<ThrowableStory> future = runningStory.getFuture();
            if (future.isDone()) continue;
            future.cancel(true);
        }
        int threads = this.embedderControls.threads();
        long threadAverage = total / (long)threads;
        storyDurations.setProperty("total", Long.toString(total));
        storyDurations.setProperty("threads", Long.toString(threads));
        storyDurations.setProperty("threadAverage", Long.toString(threadAverage));
        this.write(storyDurations, "storyDurations.props");
    }

    private void write(Properties p, String name) {
        File outputDirectory = this.configuration.storyReporterBuilder().outputDirectory();
        try {
            FileWriter output = new FileWriter(new File(outputDirectory, name));
            p.store(output, this.getClass().getName());
            ((Writer)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void tickTock() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized RunningStory submit(EnqueuedStory enqueuedStory) {
        return new RunningStory(enqueuedStory, this.executorService.submit(enqueuedStory));
    }

    public static class StoryOutcome {
        private String path;
        private Boolean done;
        private Boolean failed;

        public StoryOutcome(RunningStory story) {
            this.path = story.getStory().getPath();
            this.done = story.isDone();
            this.failed = story.isFailed();
        }

        public String getPath() {
            return this.path;
        }

        public Boolean isDone() {
            return this.done;
        }

        public Boolean isFailed() {
            return this.failed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunningStory {
        private EnqueuedStory enqueuedStory;
        private Future<ThrowableStory> future;
        private StoryDuration duration;

        public RunningStory(EnqueuedStory enqueuedStory, Future<ThrowableStory> future) {
            this.enqueuedStory = enqueuedStory;
            this.future = future;
        }

        public Future<ThrowableStory> getFuture() {
            return this.future;
        }

        public Story getStory() {
            return this.enqueuedStory.getStory();
        }

        public long getDurationInMillis() {
            if (this.duration == null) {
                return 0L;
            }
            return this.duration.getDurationInSecs() * 1000L;
        }

        public StoryDuration getDuration() {
            if (this.duration == null) {
                this.duration = new StoryDuration(this.enqueuedStory.getStartedAtMillis(), this.enqueuedStory.getTimeoutInSecs());
            }
            return this.duration;
        }

        public void updateDuration() {
            this.duration.update();
        }

        public boolean isStarted() {
            long startedAtMillis = this.enqueuedStory.getStartedAtMillis();
            return startedAtMillis != 0L;
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public boolean isFailed() {
            if (this.isDone()) {
                try {
                    return this.future.get().getThrowable() != null;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static class ThrowableStory {
        private Story story;
        private Throwable throwable;

        public ThrowableStory(Story story, Throwable throwable) {
            this.story = story;
            this.throwable = throwable;
        }

        public Story getStory() {
            return this.story;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    public static class StoryTimeout
    extends RuntimeException {
        public StoryTimeout(StoryDuration storyDuration) {
            super(storyDuration.getDurationInSecs() + "s > " + storyDuration.getTimeoutInSecs() + "s");
        }
    }

    public static class StoryExecutionFailed
    extends RuntimeException {
        public StoryExecutionFailed(String storyPath, Throwable failure) {
            super(storyPath, failure);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnqueuedStory
    implements Callable<ThrowableStory> {
        private final StoryRunner storyRunner;
        private final Configuration configuration;
        private final InjectableStepsFactory stepsFactory;
        private final EmbedderControls embedderControls;
        private final EmbedderMonitor embedderMonitor;
        private final String storyPath;
        private final Story story;
        private final MetaFilter filter;
        private final StoryRunner.State beforeStories;
        private long startedAtMillis;

        private EnqueuedStory(StoryRunner storyRunner, Configuration configuration, InjectableStepsFactory stepsFactory, EmbedderControls embedderControls, EmbedderMonitor embedderMonitor, String storyPath, Story story, MetaFilter filter, StoryRunner.State beforeStories) {
            this.storyRunner = storyRunner;
            this.configuration = configuration;
            this.stepsFactory = stepsFactory;
            this.embedderControls = embedderControls;
            this.embedderMonitor = embedderMonitor;
            this.storyPath = storyPath;
            this.story = story;
            this.filter = filter;
            this.beforeStories = beforeStories;
        }

        @Override
        public ThrowableStory call() throws Exception {
            try {
                this.embedderMonitor.runningStory(this.storyPath);
                this.startedAtMillis = System.currentTimeMillis();
                this.storyRunner.run(this.configuration, this.stepsFactory, this.story, this.filter, this.beforeStories);
            }
            catch (Throwable e) {
                if (this.embedderControls.ignoreFailureInStories()) {
                    this.embedderMonitor.storyFailed(this.storyPath, e);
                }
                return new ThrowableStory(this.story, new StoryExecutionFailed(this.storyPath, e));
            }
            return new ThrowableStory(this.story, null);
        }

        public Story getStory() {
            return this.story;
        }

        public long getStartedAtMillis() {
            return this.startedAtMillis;
        }

        public long getTimeoutInSecs() {
            return this.embedderControls.storyTimeoutInSecs();
        }
    }
}

