/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.PrintStreamEmbedderMonitor;
import org.jbehave.core.model.Meta;

public class MetaFilter {
    private static String DEFAULT_META_PREFIX_PATTERN = "(\\{0}(\\w|\\.|\\,|\\;|\\:|\\!|\\$|\\&|\\s|\\*)*)";
    public static final MetaFilter EMPTY = new MetaFilter();
    private final String filterAsString;
    private final EmbedderMonitor monitor;
    private MetaMatcher metaMatcher;

    public MetaFilter() {
        this("");
    }

    public MetaFilter(String filterAsString) {
        this(filterAsString, new PrintStreamEmbedderMonitor());
    }

    public MetaFilter(String filterAsString, EmbedderMonitor monitor) {
        this.filterAsString = filterAsString == null ? "" : filterAsString;
        this.monitor = monitor;
        this.metaMatcher = this.createMetaMatcher(this.filterAsString);
        this.metaMatcher.parse(filterAsString);
    }

    protected MetaMatcher createMetaMatcher(String filterAsString) {
        if (filterAsString.startsWith("groovy: ")) {
            return new GroovyMetaMatcher();
        }
        return new DefaultMetaMatcher();
    }

    public boolean allow(Meta meta) {
        boolean allowed = this.metaMatcher.match(meta);
        if (!allowed) {
            this.monitor.metaNotAllowed(meta, this);
        }
        return allowed;
    }

    public MetaMatcher metaMatcher() {
        return this.metaMatcher;
    }

    public String asString() {
        return this.filterAsString;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public class GroovyMetaMatcher
    implements MetaMatcher {
        private Class<?> groovyClass;
        private Field metaField;
        private Method match;

        public void parse(String filterAsString) {
            String groovyString = "public class GroovyMatcher {\npublic org.jbehave.core.model.Meta meta\n  public boolean match() {\n    return (" + filterAsString.substring("groovy: ".length()) + ")\n" + "  }\n" + "  def propertyMissing(String name) {\n" + "    if (!meta.hasProperty(name)) {\n" + "      return false\n" + "    }\n" + "    def v = meta.getProperty(name)\n" + "    if (v.equals('')) {\n" + "      return true\n" + "    }\n" + "    return v\n" + "  }\n" + "}";
            GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader());
            this.groovyClass = loader.parseClass(groovyString);
            try {
                this.match = this.groovyClass.getDeclaredMethod("match", new Class[0]);
                this.metaField = this.groovyClass.getField("meta");
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public boolean match(Meta meta) {
            try {
                Object matcher = this.groovyClass.newInstance();
                this.metaField.set(matcher, meta);
                return (Boolean)this.match.invoke(matcher, new Object[0]);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultMetaMatcher
    implements MetaMatcher {
        private final Properties include = new Properties();
        private final Properties exclude = new Properties();

        public Properties include() {
            return this.include;
        }

        public Properties exclude() {
            return this.exclude;
        }

        @Override
        public void parse(String filterAsString) {
            this.parse(this.include, "+");
            this.parse(this.exclude, "-");
        }

        @Override
        public boolean match(Meta meta) {
            boolean matched = !this.include.isEmpty() && this.exclude.isEmpty() ? this.match(this.include, meta) : (this.include.isEmpty() && !this.exclude.isEmpty() ? !this.match(this.exclude, meta) : (!this.include.isEmpty() && !this.exclude.isEmpty() ? this.match(this.merge(this.include, this.exclude), meta) && !this.match(this.exclude, meta) : true));
            return matched;
        }

        private void parse(Properties properties, String prefix) {
            properties.clear();
            for (String found : this.found(prefix)) {
                Meta.Property property = new Meta.Property(StringUtils.removeStartIgnoreCase((String)found, (String)prefix));
                properties.setProperty(property.getName(), property.getValue());
            }
        }

        private Set<String> found(String prefix) {
            Matcher matcher = this.findAllPrefixed(prefix).matcher(MetaFilter.this.filterAsString);
            HashSet<String> found = new HashSet<String>();
            while (matcher.find()) {
                found.add(matcher.group().trim());
            }
            return found;
        }

        private Pattern findAllPrefixed(String prefix) {
            return Pattern.compile(MessageFormat.format(DEFAULT_META_PREFIX_PATTERN, prefix), 32);
        }

        private Properties merge(Properties include, Properties exclude) {
            HashSet<Object> in = new HashSet<Object>(include.keySet());
            in.addAll(exclude.keySet());
            Properties merged = new Properties();
            for (Object e : in) {
                if (include.containsKey(e)) {
                    merged.put(e, include.get(e));
                    continue;
                }
                if (!exclude.containsKey(e)) continue;
                merged.put(e, exclude.get(e));
            }
            return merged;
        }

        private boolean match(Properties properties, Meta meta) {
            boolean matches = false;
            block0: for (Object key : properties.keySet()) {
                String property = (String)properties.get(key);
                for (String metaName : meta.getPropertyNames()) {
                    if (key.equals(metaName)) {
                        String value = meta.getProperty(metaName);
                        matches = StringUtils.isBlank((String)value) ? true : (property.contains("*") ? value.matches(property.replace("*", ".*")) : properties.get(key).equals(value));
                    }
                    if (!matches) continue;
                    continue block0;
                }
            }
            return matches;
        }
    }

    public static interface MetaMatcher {
        public void parse(String var1);

        public boolean match(Meta var1);
    }
}

