/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.Alias;
import org.jbehave.core.annotations.Aliases;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.steps.CandidateStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Steps
implements CandidateSteps {
    private final Configuration configuration;
    private final Object instance;
    private StepCreator stepCreator;

    public Steps() {
        this(new MostUsefulConfiguration());
    }

    public Steps(Configuration configuration) {
        this(configuration, null);
    }

    public Steps(Configuration configuration, Object instance) {
        this.configuration = configuration;
        this.instance = instance;
        this.stepCreator = new StepCreator(this.instance(), configuration.stepMonitor());
    }

    Object instance() {
        if (this.instance == null) {
            return this;
        }
        return this.instance;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public List<CandidateStep> listCandidates() {
        ArrayList<CandidateStep> candidates = new ArrayList<CandidateStep>();
        for (Method method : this.allMethods()) {
            int priority;
            String value;
            Annotation annotation;
            if (method.isAnnotationPresent(Given.class)) {
                annotation = method.getAnnotation(Given.class);
                value = this.encode(annotation.value());
                priority = annotation.priority();
                this.addCandidateStep(candidates, method, StepType.GIVEN, value, priority);
                this.addCandidateStepsFromAliases(candidates, method, StepType.GIVEN, priority);
            }
            if (method.isAnnotationPresent(When.class)) {
                annotation = method.getAnnotation(When.class);
                value = this.encode(annotation.value());
                priority = annotation.priority();
                this.addCandidateStep(candidates, method, StepType.WHEN, value, priority);
                this.addCandidateStepsFromAliases(candidates, method, StepType.WHEN, priority);
            }
            if (!method.isAnnotationPresent(Then.class)) continue;
            annotation = method.getAnnotation(Then.class);
            value = this.encode(annotation.value());
            priority = annotation.priority();
            this.addCandidateStep(candidates, method, StepType.THEN, value, priority);
            this.addCandidateStepsFromAliases(candidates, method, StepType.THEN, priority);
        }
        return candidates;
    }

    private String encode(String value) {
        return this.configuration.keywords().encode(value);
    }

    private void addCandidateStep(List<CandidateStep> candidates, Method method, StepType stepType, String stepPatternAsString, int priority) {
        this.checkForDuplicateCandidateSteps(candidates, stepType, stepPatternAsString);
        CandidateStep step = this.createCandidateStep(method, stepType, stepPatternAsString, priority, this.configuration);
        step.useStepMonitor(this.configuration.stepMonitor());
        step.useParanamer(this.configuration.paranamer());
        step.doDryRun(this.configuration.dryRun());
        candidates.add(step);
    }

    private void checkForDuplicateCandidateSteps(List<CandidateStep> candidates, StepType stepType, String patternAsString) {
        for (CandidateStep candidate : candidates) {
            if (candidate.getStepType() != stepType || !candidate.getPatternAsString().equals(patternAsString)) continue;
            throw new DuplicateCandidateStepFoundException(stepType, patternAsString);
        }
    }

    private void addCandidateStepsFromAliases(List<CandidateStep> candidates, Method method, StepType stepType, int priority) {
        if (method.isAnnotationPresent(Aliases.class)) {
            String[] aliases;
            for (String alias : aliases = method.getAnnotation(Aliases.class).values()) {
                this.addCandidateStep(candidates, method, stepType, alias, priority);
            }
        }
        if (method.isAnnotationPresent(Alias.class)) {
            String alias = method.getAnnotation(Alias.class).value();
            this.addCandidateStep(candidates, method, stepType, alias, priority);
        }
    }

    private CandidateStep createCandidateStep(Method method, StepType stepType, String stepPatternAsString, int priority, Configuration configuration) {
        return new CandidateStep(stepPatternAsString, priority, stepType, method, this.instance(), configuration.stepPatternParser(), configuration.parameterConverters(), configuration.keywords().startingWordsByType());
    }

    @Override
    public List<Step> runBeforeStory(boolean givenStory) {
        return this.storyStepsHaving(BeforeStory.class, givenStory);
    }

    @Override
    public List<Step> runAfterStory(boolean givenStory) {
        return this.storyStepsHaving(AfterStory.class, givenStory);
    }

    private List<Step> storyStepsHaving(Class<? extends Annotation> annotationClass, boolean givenStory) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Method method : this.annotatatedMethods(annotationClass)) {
            if (!this.runnableStoryStep(method.getAnnotation(annotationClass), givenStory)) continue;
            steps.add(this.stepCreator.createBeforeOrAfterStep(method));
        }
        return steps;
    }

    private boolean runnableStoryStep(Annotation annotation, boolean givenStory) {
        boolean uponGivenStory = this.uponGivenStory(annotation);
        return uponGivenStory == givenStory;
    }

    private boolean uponGivenStory(Annotation annotation) {
        if (annotation instanceof BeforeStory) {
            return ((BeforeStory)annotation).uponGivenStory();
        }
        if (annotation instanceof AfterStory) {
            return ((AfterStory)annotation).uponGivenStory();
        }
        return false;
    }

    @Override
    public List<Step> runBeforeScenario() {
        return this.scenarioStepsHaving(BeforeScenario.class);
    }

    @Override
    public List<Step> runAfterScenario() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.addAll(this.scenarioStepsHavingOutcome(AfterScenario.class, AfterScenario.Outcome.ANY));
        steps.addAll(this.scenarioStepsHavingOutcome(AfterScenario.class, AfterScenario.Outcome.SUCCESS));
        steps.addAll(this.scenarioStepsHavingOutcome(AfterScenario.class, AfterScenario.Outcome.FAILURE));
        return steps;
    }

    private List<Step> scenarioStepsHaving(Class<? extends Annotation> annotationClass) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Method method : this.annotatatedMethods(annotationClass)) {
            steps.add(this.stepCreator.createBeforeOrAfterStep(method));
        }
        return steps;
    }

    private List<Step> scenarioStepsHavingOutcome(Class<? extends AfterScenario> annotationClass, AfterScenario.Outcome outcome) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Method method : this.annotatatedMethods(annotationClass)) {
            AfterScenario annotation = method.getAnnotation(annotationClass);
            if (!outcome.equals((Object)annotation.uponOutcome())) continue;
            steps.add(this.stepCreator.createAfterStepUponOutcome(method, outcome));
        }
        return steps;
    }

    private List<Method> allMethods() {
        return Arrays.asList(this.instance().getClass().getMethods());
    }

    private List<Method> annotatatedMethods(Class<? extends Annotation> annotationClass) {
        ArrayList<Method> annotated = new ArrayList<Method>();
        for (Method method : this.allMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            annotated.add(method);
        }
        return annotated;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class DuplicateCandidateStepFoundException
    extends RuntimeException {
        public DuplicateCandidateStepFoundException(StepType stepType, String patternAsString) {
            super((Object)((Object)stepType) + " " + patternAsString);
        }
    }
}

