/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.steps.CandidateSteps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stepdoc
implements Comparable<Stepdoc> {
    private final Class<? extends Annotation> annotation;
    private final String pattern;
    private final List<String> aliasPatterns;
    private final Method method;
    private final CandidateSteps candidateSteps;
    private Integer priority = 0;

    public Stepdoc(Class<? extends Annotation> annotation, String pattern, String[] aliasPatterns, Method method, CandidateSteps candidateSteps) {
        this.annotation = annotation;
        this.pattern = pattern;
        this.aliasPatterns = Arrays.asList(aliasPatterns);
        this.method = method;
        this.candidateSteps = candidateSteps;
        this.assignPriority();
    }

    private void assignPriority() {
        if (this.annotation.equals(Given.class)) {
            this.priority = 1;
        } else if (this.annotation.equals(When.class)) {
            this.priority = 2;
        } else if (this.annotation.equals(Then.class)) {
            this.priority = 3;
        }
    }

    public Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<String> getAliasPatterns() {
        return this.aliasPatterns;
    }

    public Method getMethod() {
        return this.method;
    }

    public CandidateSteps getCandidateSteps() {
        return this.candidateSteps;
    }

    public String getMethodSignature() {
        String methodSignature = this.method.toString();
        return methodSignature.replaceFirst("public void ", "");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Stepdoc pattern=").append(this.pattern).append(", aliases=").append(this.aliasPatterns).append(", method=").append(this.getMethodSignature()).append(", candidateSteps=").append(this.candidateSteps.getClass()).append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(Stepdoc that) {
        int compare = this.priority.compareTo(that.priority);
        if (compare == 0) {
            compare = this.pattern.compareTo(that.pattern);
        }
        return compare;
    }
}

