/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Named;
import org.jbehave.core.failures.BeforeOrAfterFailed;
import org.jbehave.core.failures.PendingStepFound;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepResult;
import org.jbehave.paranamer.NullParanamer;
import org.jbehave.paranamer.Paranamer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepCreator {
    public static final String PARAMETER_NAME_START = "<";
    public static final String PARAMETER_NAME_END = ">";
    public static final String PARAMETER_VALUE_START = "\uff5f";
    public static final String PARAMETER_VALUE_END = "\uff60";
    public static final String PARAMETER_VALUE_NEWLINE = "NL";
    private final Object stepsInstance;
    private final ParameterConverters parameterConverters;
    private final StepMatcher stepMatcher;
    private final StepRunner beforeOrAfter;
    private final StepRunner skip;
    private StepMonitor stepMonitor;
    private Paranamer paranamer = new NullParanamer();
    private boolean dryRun = false;

    public StepCreator(Object stepsInstance, StepMonitor stepMonitor) {
        this(stepsInstance, null, null, stepMonitor);
    }

    public StepCreator(Object stepsInstance, ParameterConverters parameterConverters, StepMatcher stepMatcher, StepMonitor stepMonitor) {
        this.stepsInstance = stepsInstance;
        this.parameterConverters = parameterConverters;
        this.stepMatcher = stepMatcher;
        this.stepMonitor = stepMonitor;
        this.beforeOrAfter = new BeforeOrAfter();
        this.skip = new Skip();
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
    }

    public void useParanamer(Paranamer paranamer) {
        this.paranamer = paranamer;
    }

    public void doDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Step createBeforeOrAfterStep(final Method method) {
        return new Step(){

            public StepResult doNotPerform() {
                return StepCreator.this.beforeOrAfter.run(method);
            }

            public StepResult perform() {
                return StepCreator.this.beforeOrAfter.run(method);
            }
        };
    }

    public Step createAfterStepUponOutcome(final Method method, AfterScenario.Outcome outcome) {
        switch (outcome) {
            default: {
                return new Step(){

                    public StepResult doNotPerform() {
                        return StepCreator.this.beforeOrAfter.run(method);
                    }

                    public StepResult perform() {
                        return StepCreator.this.beforeOrAfter.run(method);
                    }
                };
            }
            case SUCCESS: {
                return new Step(){

                    public StepResult doNotPerform() {
                        return StepCreator.this.skip.run(method);
                    }

                    public StepResult perform() {
                        return StepCreator.this.beforeOrAfter.run(method);
                    }
                };
            }
            case FAILURE: 
        }
        return new Step(){

            public StepResult doNotPerform() {
                return StepCreator.this.beforeOrAfter.run(method);
            }

            public StepResult perform() {
                return StepCreator.this.skip.run(method);
            }
        };
    }

    public Step createParametrisedStep(final Method method, final String stepAsString, Map<String, String> tableRow) {
        String[] annotationNames = this.annotatedParameterNames(method);
        String[] parameterNames = this.paranamer.lookupParameterNames(method, false);
        final Type[] types = method.getGenericParameterTypes();
        final String[] args = this.argsForStep(tableRow, types, annotationNames, parameterNames);
        final String parametrisedStep = this.parametrisedStep(stepAsString, tableRow, types, annotationNames, parameterNames, args);
        return new Step(){

            public StepResult perform() {
                try {
                    StepCreator.this.stepMonitor.performing(stepAsString, StepCreator.this.dryRun);
                    if (!StepCreator.this.dryRun) {
                        method.invoke(StepCreator.this.stepsInstance, StepCreator.this.convertArgs(args, types));
                    }
                    return AbstractStepResult.successful(stepAsString).withParameterValues(parametrisedStep);
                }
                catch (Throwable t) {
                    return this.failedOrPending(stepAsString, t);
                }
            }

            private StepResult failedOrPending(String stepAsString2, Throwable t) {
                if (t instanceof InvocationTargetException && t.getCause() != null) {
                    Throwable cause = t.getCause();
                    if (cause instanceof PendingStepFound) {
                        return AbstractStepResult.pending(stepAsString2, (PendingStepFound)((Object)cause)).withParameterValues(parametrisedStep);
                    }
                    return AbstractStepResult.failed(stepAsString2, cause).withParameterValues(parametrisedStep);
                }
                return AbstractStepResult.failed(stepAsString2, t).withParameterValues(parametrisedStep);
            }

            public StepResult doNotPerform() {
                return AbstractStepResult.notPerformed(stepAsString).withParameterValues(parametrisedStep);
            }
        };
    }

    private String[] annotatedParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterAnnotations.length];
        for (int x = 0; x < parameterAnnotations.length; ++x) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[x]) {
                names[x] = this.annotationName(annotation);
            }
        }
        return names;
    }

    private String annotationName(Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(Named.class)) {
            return ((Named)annotation).value();
        }
        if ("javax.inject.Named".equals(annotation.annotationType().getName())) {
            return Jsr330Helper.getNamedValue(annotation);
        }
        return null;
    }

    private String parametrisedStep(String stepAsString, Map<String, String> tableRow, Type[] types, String[] annotationNames, String[] parameterNames, String[] args) {
        String parametrisedStep = stepAsString;
        for (int position = 0; position < types.length; ++position) {
            parametrisedStep = this.replaceParameterValuesInStep(parametrisedStep, position, annotationNames, parameterNames, args, tableRow);
        }
        return parametrisedStep;
    }

    private String replaceParameterValuesInStep(String stepText, int position, String[] annotationNames, String[] parameterNames, String[] args, Map<String, String> tableRow) {
        int annotatedNamePosition = this.parameterPosition(annotationNames, position);
        int parameterNamePosition = this.parameterPosition(parameterNames, position);
        if (annotatedNamePosition != -1) {
            stepText = this.replaceTableValue(stepText, tableRow, annotationNames[position]);
        } else if (parameterNamePosition != -1) {
            stepText = this.replaceTableValue(stepText, tableRow, parameterNames[position]);
        }
        stepText = this.replaceArgValue(stepText, position, args);
        return stepText;
    }

    private String replaceArgValue(String stepText, int position, String[] args) {
        String value = args[position];
        if (value != null) {
            stepText = stepText.replace(value, PARAMETER_VALUE_START + value + PARAMETER_VALUE_END);
            stepText = stepText.replace("\n", PARAMETER_VALUE_NEWLINE);
        }
        return stepText;
    }

    private String replaceTableValue(String stepText, Map<String, String> tableRow, String name) {
        String value = this.getTableValue(tableRow, name);
        if (value != null) {
            stepText = stepText.replace(PARAMETER_NAME_START + name + PARAMETER_NAME_END, PARAMETER_VALUE_START + value + PARAMETER_VALUE_END);
        }
        return stepText;
    }

    private String[] argsForStep(Map<String, String> tableRow, Type[] types, String[] annotationNames, String[] parameterNames) {
        String[] args = new String[types.length];
        for (int position = 0; position < types.length; ++position) {
            args[position] = this.argForPosition(position, annotationNames, parameterNames, tableRow);
        }
        return args;
    }

    private Object[] convertArgs(String[] argsAsString, Type[] types) {
        Object[] args = new Object[argsAsString.length];
        for (int position = 0; position < argsAsString.length; ++position) {
            args[position] = this.parameterConverters.convert(argsAsString[position], types[position]);
        }
        return args;
    }

    private String argForPosition(int position, String[] annotationNames, String[] parameterNames, Map<String, String> tableRow) {
        int annotatedNamePosition = this.parameterPosition(annotationNames, position);
        int parameterNamePosition = this.parameterPosition(parameterNames, position);
        String arg = null;
        if (annotatedNamePosition != -1 && this.isGroupName(annotationNames[position])) {
            String name = annotationNames[position];
            this.stepMonitor.usingAnnotatedNameForArg(name, position);
            arg = this.matchedParameter(name);
        } else if (parameterNamePosition != -1 && this.isGroupName(parameterNames[position])) {
            String name = parameterNames[position];
            this.stepMonitor.usingParameterNameForArg(name, position);
            arg = this.matchedParameter(name);
        } else if (annotatedNamePosition != -1 && this.isTableFieldName(tableRow, annotationNames[position])) {
            String name = annotationNames[position];
            this.stepMonitor.usingTableAnnotatedNameForArg(name, position);
            arg = this.getTableValue(tableRow, name);
        } else if (parameterNamePosition != -1 && this.isTableFieldName(tableRow, parameterNames[position])) {
            String name = parameterNames[position];
            this.stepMonitor.usingTableParameterNameForArg(name, position);
            arg = this.getTableValue(tableRow, name);
        } else {
            this.stepMonitor.usingNaturalOrderForArg(position);
            arg = this.matchedParameter(position);
        }
        this.stepMonitor.foundArg(arg, position);
        return arg;
    }

    private String matchedParameter(String name) {
        String[] parameterNames = this.stepMatcher.parameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            if (!name.equals(parameterName)) continue;
            return this.matchedParameter(i);
        }
        throw new NoParameterFoundForName(name, parameterNames);
    }

    private String matchedParameter(int i) {
        return this.stepMatcher.parameter(i + 1);
    }

    private int parameterPosition(String[] names, int position) {
        if (names.length == 0) {
            return -1;
        }
        String positionName = names[position];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null || !positionName.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private boolean isGroupName(String name) {
        String[] groupNames;
        for (String groupName : groupNames = this.stepMatcher.parameterNames()) {
            if (!name.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    private String getTableValue(Map<String, String> tableRow, String name) {
        return tableRow.get(name);
    }

    private boolean isTableFieldName(Map<String, String> tableRow, String name) {
        return tableRow.get(name) != null;
    }

    public static Step createPendingStep(final String stepAsString) {
        return new Step(){

            public StepResult perform() {
                return AbstractStepResult.pending(stepAsString);
            }

            public StepResult doNotPerform() {
                return AbstractStepResult.pending(stepAsString);
            }
        };
    }

    public static Step createIgnorableStep(final String stepAsString) {
        return new Step(){

            public StepResult perform() {
                return AbstractStepResult.ignorable(stepAsString);
            }

            public StepResult doNotPerform() {
                return AbstractStepResult.ignorable(stepAsString);
            }
        };
    }

    public static class NoParameterFoundForName
    extends RuntimeException {
        public NoParameterFoundForName(String name, String[] names) {
            super("No parameter found for name '" + name + "' amongst '" + Arrays.asList(names) + "'");
        }
    }

    public static class Jsr330Helper {
        private static String getNamedValue(Annotation annotation) {
            return ((javax.inject.Named)annotation).value();
        }
    }

    private class Skip
    implements StepRunner {
        private Skip() {
        }

        public StepResult run(Method method) {
            return AbstractStepResult.skipped();
        }
    }

    private class BeforeOrAfter
    implements StepRunner {
        private BeforeOrAfter() {
        }

        public StepResult run(Method method) {
            try {
                method.invoke(StepCreator.this.stepsInstance, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw new BeforeOrAfterFailed(method, e.getCause());
                }
                throw new RuntimeException(e);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return AbstractStepResult.skipped();
        }
    }

    public static interface StepRunner {
        public StepResult run(Method var1);
    }
}

