/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintStreamStepMonitor
implements StepMonitor {
    private static final String CONVERTED_VALUE_OF_TYPE = "Converted value ''{0}'' of type ''{1}'' to ''{2}'' with converter ''{3}''";
    private static final String STEP_MATCHES_TYPE = "Step ''{0}'' (with previous step ''{1}'') ''{2}'' type ''{3}'' for method ''{4}'' with annotations ''{5}'' in steps instance ''{6}''";
    private static final String STEP_MATCHES_PATTERN = "Step ''{0}'' {1} pattern ''{2}'' for method ''{3}'' with annotations ''{4}'' in steps instance ''{5}''";
    private static final String PERFORMING = "Performing step ''{0}'' {1}";
    private static final String DRY_RUN = "(DRY RUN)";
    private static final String MATCHES = "matches";
    private static final String DOES_NOT_MATCH = "does not match";
    private static final String USING_NAME_FOR_ARG = "Using {0} name ''{1}'' for position {2}";
    private static final String ANNOTATED = "annotated";
    private static final String PARAMETER = "parameter";
    private static final String TABLE_ANNOTATED = "table annotated";
    private static final String TABLE_PARAMETER = "table parameter";
    private static final String USING_NATURAL_ORDER_FOR_ARG = "Using natural order for position {0}";
    private static final String FOUND_ARG = "Found argument ''{0}'' for position {1}";
    private final PrintStream output;

    public PrintStreamStepMonitor() {
        this(System.out);
    }

    public PrintStreamStepMonitor(PrintStream output) {
        this.output = output;
    }

    @Override
    public void stepMatchesType(String step, String previous, boolean matches, StepType stepType, Method method, Object stepsInstance) {
        String message = MessageFormat.format(STEP_MATCHES_TYPE, new Object[]{step, previous, matches ? MATCHES : DOES_NOT_MATCH, stepType, method, Arrays.asList(method.getAnnotations()), stepsInstance});
        this.print(this.output, message);
    }

    @Override
    public void stepMatchesPattern(String step, boolean matches, String pattern, Method method, Object stepsInstance) {
        String message = MessageFormat.format(STEP_MATCHES_PATTERN, step, matches ? MATCHES : DOES_NOT_MATCH, pattern, method, Arrays.asList(method.getAnnotations()), stepsInstance);
        this.print(this.output, message);
    }

    @Override
    public void convertedValueOfType(String value, Type type, Object converted, Class<?> converterClass) {
        String message = MessageFormat.format(CONVERTED_VALUE_OF_TYPE, value, type, converted, converterClass);
        this.print(this.output, message);
    }

    @Override
    public void performing(String step, boolean dryRun) {
        String message = MessageFormat.format(PERFORMING, step, dryRun ? DRY_RUN : "");
        this.print(this.output, message);
    }

    @Override
    public void usingAnnotatedNameForArg(String name, int position) {
        String message = MessageFormat.format(USING_NAME_FOR_ARG, ANNOTATED, name, position);
        this.print(this.output, message);
    }

    @Override
    public void usingParameterNameForArg(String name, int position) {
        String message = MessageFormat.format(USING_NAME_FOR_ARG, PARAMETER, name, position);
        this.print(this.output, message);
    }

    @Override
    public void usingTableAnnotatedNameForArg(String name, int position) {
        String message = MessageFormat.format(USING_NAME_FOR_ARG, TABLE_ANNOTATED, name, position);
        this.print(this.output, message);
    }

    @Override
    public void usingTableParameterNameForArg(String name, int position) {
        String message = MessageFormat.format(USING_NAME_FOR_ARG, TABLE_PARAMETER, name, position);
        this.print(this.output, message);
    }

    @Override
    public void usingNaturalOrderForArg(int position) {
        String message = MessageFormat.format(USING_NATURAL_ORDER_FOR_ARG, position);
        this.print(this.output, message);
    }

    @Override
    public void foundArg(String arg, int position) {
        String message = MessageFormat.format(FOUND_ARG, arg, position);
        this.print(this.output, message);
    }

    protected void print(PrintStream output, String message) {
        output.println(message);
    }
}

