/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.steps.CandidateStep;
import org.jbehave.core.steps.CandidateStepFinder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkUnmatchedStepsAsPending
implements StepCollector {
    private CandidateStepFinder stepFinder = new CandidateStepFinder();

    @Override
    public List<Step> collectStepsFrom(List<CandidateSteps> candidateSteps, Story story, StepCollector.Stage stage, boolean givenStory) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            switch (stage) {
                case BEFORE: {
                    steps.addAll(candidates.runBeforeStory(givenStory));
                    break;
                }
                case AFTER: {
                    steps.addAll(candidates.runAfterStory(givenStory));
                    break;
                }
            }
        }
        return steps;
    }

    @Override
    public List<Step> collectStepsFrom(List<CandidateSteps> candidateSteps, Scenario scenario, Map<String, String> tableRow) {
        ArrayList<Step> steps = new ArrayList<Step>();
        this.addMatchedScenarioSteps(scenario, steps, tableRow, candidateSteps);
        this.addBeforeAndAfterScenarioSteps(steps, candidateSteps);
        return steps;
    }

    private void addBeforeAndAfterScenarioSteps(List<Step> steps, List<CandidateSteps> candidateSteps) {
        for (CandidateSteps candidates : candidateSteps) {
            steps.addAll(0, candidates.runBeforeScenario());
        }
        for (CandidateSteps candidates : candidateSteps) {
            steps.addAll(candidates.runAfterScenario());
        }
    }

    private void addMatchedScenarioSteps(Scenario scenario, List<Step> steps, Map<String, String> tableRow, List<CandidateSteps> candidateSteps) {
        List<CandidateStep> prioritisedCandidates = this.stepFinder.collectAndPrioritise(candidateSteps);
        String previousNonAndStep = null;
        for (String stepAsString : scenario.getSteps()) {
            Step step = StepCreator.createPendingStep(stepAsString);
            for (CandidateStep candidate : prioritisedCandidates) {
                if (candidate.ignore(stepAsString)) {
                    step = StepCreator.createIgnorableStep(stepAsString);
                    break;
                }
                if (!this.matchesCandidate(stepAsString, previousNonAndStep, candidate)) continue;
                step = candidate.createMatchedStep(stepAsString, tableRow);
                if (candidate.isAndStep(stepAsString)) break;
                previousNonAndStep = stepAsString;
                break;
            }
            steps.add(step);
        }
    }

    private boolean matchesCandidate(String step, String previousNonAndStep, CandidateStep candidate) {
        if (previousNonAndStep != null) {
            return candidate.matches(step, previousNonAndStep);
        }
        return candidate.matches(step);
    }
}

