/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.Aliases;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.Stepdoc;
import org.jbehave.core.steps.StepdocGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStepdocGenerator
implements StepdocGenerator {
    private static final String EMPTY_VALUE = "";
    private static final String[] NO_ALIASES = new String[0];

    @Override
    public List<Stepdoc> generate(CandidateSteps ... steps) {
        LinkedList<Stepdoc> stepdocs = new LinkedList<Stepdoc>();
        for (CandidateSteps candidateSteps : steps) {
            stepdocs.addAll(this.generate(candidateSteps));
        }
        Collections.sort(stepdocs);
        return stepdocs;
    }

    private List<Stepdoc> generate(CandidateSteps candidateSteps) {
        LinkedList<Stepdoc> stepdocs = new LinkedList<Stepdoc>();
        for (Method method : candidateSteps.getClass().getMethods()) {
            if (method.isAnnotationPresent(Given.class)) {
                stepdocs.add(new Stepdoc(Given.class, method.getAnnotation(Given.class).value(), this.aliases(method), method, candidateSteps));
            }
            if (method.isAnnotationPresent(When.class)) {
                stepdocs.add(new Stepdoc(When.class, method.getAnnotation(When.class).value(), this.aliases(method), method, candidateSteps));
            }
            if (method.isAnnotationPresent(Then.class)) {
                stepdocs.add(new Stepdoc(Then.class, method.getAnnotation(Then.class).value(), this.aliases(method), method, candidateSteps));
            }
            if (method.isAnnotationPresent(BeforeScenario.class)) {
                stepdocs.add(new Stepdoc(BeforeScenario.class, EMPTY_VALUE, NO_ALIASES, method, candidateSteps));
            }
            if (method.isAnnotationPresent(AfterScenario.class)) {
                stepdocs.add(new Stepdoc(AfterScenario.class, EMPTY_VALUE, NO_ALIASES, method, candidateSteps));
            }
            if (method.isAnnotationPresent(BeforeStory.class)) {
                stepdocs.add(new Stepdoc(BeforeStory.class, EMPTY_VALUE, NO_ALIASES, method, candidateSteps));
            }
            if (!method.isAnnotationPresent(AfterStory.class)) continue;
            stepdocs.add(new Stepdoc(AfterStory.class, EMPTY_VALUE, NO_ALIASES, method, candidateSteps));
        }
        return stepdocs;
    }

    private String[] aliases(Method method) {
        if (method.isAnnotationPresent(Aliases.class)) {
            return method.getAnnotation(Aliases.class).values();
        }
        return NO_ALIASES;
    }
}

