/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jbehave.core.steps.CandidateStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.Steps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateStepFinder {
    public List<CandidateStep> findMatching(String stepAsString, List<CandidateSteps> candidateSteps) {
        ArrayList<CandidateStep> matching = new ArrayList<CandidateStep>();
        for (CandidateStep candidate : this.collect(candidateSteps)) {
            if (!candidate.matches(stepAsString)) continue;
            matching.add(candidate);
        }
        return matching;
    }

    public List<Object> stepsInstances(List<CandidateSteps> candidateSteps) {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (CandidateSteps steps : candidateSteps) {
            if (!(steps instanceof Steps)) continue;
            instances.add(((Steps)steps).instance());
        }
        return instances;
    }

    public List<CandidateStep> collectAndPrioritise(List<CandidateSteps> candidateSteps) {
        return this.prioritise(this.collect(candidateSteps));
    }

    private List<CandidateStep> collect(List<CandidateSteps> candidateSteps) {
        ArrayList<CandidateStep> collected = new ArrayList<CandidateStep>();
        for (CandidateSteps candidates : candidateSteps) {
            collected.addAll(candidates.listCandidates());
        }
        return collected;
    }

    private List<CandidateStep> prioritise(List<CandidateStep> candidateSteps) {
        ArrayList<CandidateStep> prioritised = new ArrayList<CandidateStep>(candidateSteps);
        Collections.sort(prioritised, new Comparator<CandidateStep>(){

            @Override
            public int compare(CandidateStep o1, CandidateStep o2) {
                return -1 * o1.getPriority().compareTo(o2.getPriority());
            }
        });
        return prioritised;
    }
}

