/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import java.util.Map;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;
import org.jbehave.paranamer.Paranamer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateStep {
    private final String patternAsString;
    private final Integer priority;
    private final StepType stepType;
    private final Method method;
    private final Object stepsInstance;
    private final Map<StepType, String> startingWordsByType;
    private final StepMatcher stepMatcher;
    private final StepCreator stepCreator;
    private StepMonitor stepMonitor = new SilentStepMonitor();

    public CandidateStep(String patternAsString, int priority, StepType stepType, Method method, Object stepsInstance, StepPatternParser stepPatternParser, ParameterConverters parameterConverters, Map<StepType, String> startingWords) {
        this.patternAsString = patternAsString;
        this.priority = priority;
        this.stepType = stepType;
        this.method = method;
        this.stepsInstance = stepsInstance;
        this.startingWordsByType = startingWords;
        this.stepMatcher = stepPatternParser.parseStep(patternAsString);
        this.stepCreator = new StepCreator(stepsInstance, parameterConverters, this.stepMatcher, this.stepMonitor);
    }

    public Method getMethod() {
        return this.method;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public StepType getStepType() {
        return this.stepType;
    }

    public String getPatternAsString() {
        return this.patternAsString;
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        this.stepCreator.useStepMonitor(stepMonitor);
    }

    public void doDryRun(boolean dryRun) {
        this.stepCreator.doDryRun(dryRun);
    }

    public void useParanamer(Paranamer paranamer) {
        this.stepCreator.useParanamer(paranamer);
    }

    public boolean ignore(String stepAsString) {
        try {
            String ignoreWord = this.startingWordFor(StepType.IGNORABLE);
            return stepAsString.startsWith(ignoreWord);
        }
        catch (StartingWordNotFound e) {
            return false;
        }
    }

    public boolean matches(String stepAsString) {
        return this.matches(stepAsString, null);
    }

    public boolean matches(String step, String previousNonAndStep) {
        try {
            boolean matchesType = true;
            if (this.isAndStep(step)) {
                matchesType = previousNonAndStep == null ? false : this.startingWordFor(this.stepType).equals(this.findStartingWord(previousNonAndStep));
            }
            this.stepMonitor.stepMatchesType(step, previousNonAndStep, matchesType, this.stepType, this.method, this.stepsInstance);
            boolean matchesPattern = this.stepMatcher.matches(this.stripStartingWord(step));
            this.stepMonitor.stepMatchesPattern(step, matchesPattern, this.stepMatcher.pattern(), this.method, this.stepsInstance);
            return matchesType && matchesPattern;
        }
        catch (StartingWordNotFound e) {
            return false;
        }
    }

    public boolean isAndStep(String stepAsString) {
        return stepAsString.startsWith(this.startingWordFor(StepType.AND));
    }

    public Step createMatchedStep(String stepAsString, Map<String, String> tableRow) {
        this.stepMatcher.find(this.stripStartingWord(stepAsString));
        return this.stepCreator.createParametrisedStep(this.method, stepAsString, tableRow);
    }

    private String stripStartingWord(String stepAsString) {
        String startingWord = this.findStartingWord(stepAsString);
        return this.trimStartingWord(startingWord, stepAsString);
    }

    private String findStartingWord(String stepAsString) throws StartingWordNotFound {
        String wordForType = this.startingWordFor(this.stepType);
        if (stepAsString.startsWith(wordForType)) {
            return wordForType;
        }
        String andWord = this.startingWordFor(StepType.AND);
        if (stepAsString.startsWith(andWord)) {
            return andWord;
        }
        throw new StartingWordNotFound(stepAsString, this.stepType, this.startingWordsByType);
    }

    private String trimStartingWord(String word, String step) {
        return step.substring(word.length() + 1);
    }

    private String startingWordFor(StepType stepType) {
        String startingWord = this.startingWordsByType.get((Object)stepType);
        if (startingWord == null) {
            throw new StartingWordNotFound(stepType, this.startingWordsByType);
        }
        return startingWord;
    }

    public String toString() {
        return (Object)((Object)this.stepType) + " " + this.patternAsString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartingWordNotFound
    extends RuntimeException {
        public StartingWordNotFound(String step, StepType stepType, Map<StepType, String> startingWordsByType) {
            super("No starting word found for step '" + step + "' of type '" + (Object)((Object)stepType) + "' amongst '" + startingWordsByType + "'");
        }

        public StartingWordNotFound(StepType stepType, Map<StepType, String> startingWordsByType) {
            super("No starting word found of type '" + (Object)((Object)stepType) + "' amongst '" + startingWordsByType + "'");
        }
    }
}

