/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbehave.core.io.CodeLocations;
import org.jbehave.core.io.StoryLocation;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.reporters.DelegatingStoryReporter;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.FreemarkerViewGenerator;
import org.jbehave.core.reporters.HtmlOutput;
import org.jbehave.core.reporters.IdeOnlyConsoleOutput;
import org.jbehave.core.reporters.PostStoryStatisticsCollector;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.TxtOutput;
import org.jbehave.core.reporters.XmlOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryReporterBuilder {
    private List<Format> formats = new ArrayList<Format>();
    private String outputDirectory = new FilePrintStreamFactory.FileConfiguration().getOutputDirectory();
    private URL codeLocation = CodeLocations.codeLocationFromPath("target/classes");
    private Properties viewResources = FreemarkerViewGenerator.defaultResources();
    private boolean reportFailureTrace = false;

    public File outputDirectory() {
        return this.filePrintStreamFactory("").outputDirectory();
    }

    public List<String> formatNames(boolean toLowerCase) {
        ArrayList<String> names = new ArrayList<String>();
        for (Format format : this.formats) {
            String name = format.name();
            if (toLowerCase) {
                name = name.toLowerCase();
            }
            names.add(name);
        }
        return names;
    }

    public Properties viewResources() {
        return this.viewResources;
    }

    public StoryReporterBuilder withOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public StoryReporterBuilder withCodeLocation(URL codeLocation) {
        this.codeLocation = codeLocation;
        return this;
    }

    public StoryReporterBuilder withDefaultFormats() {
        return this.withFormats(Format.STATS);
    }

    public StoryReporterBuilder withFormats(Format ... formats) {
        this.formats.addAll(Arrays.asList(formats));
        return this;
    }

    public StoryReporterBuilder withFailureTrace(boolean reportFailureTrace) {
        this.reportFailureTrace = reportFailureTrace;
        return this;
    }

    public StoryReporterBuilder withViewResources(Properties resources) {
        this.viewResources = resources;
        return this;
    }

    public StoryReporter build(String storyPath) {
        HashMap<Format, StoryReporter> delegates = new HashMap<Format, StoryReporter>();
        for (Format format : this.formats) {
            delegates.put(format, this.reporterFor(storyPath, format));
        }
        return new DelegatingStoryReporter(delegates.values());
    }

    public Map<String, StoryReporter> build(List<String> storyPaths) {
        HashMap<String, StoryReporter> reporters = new HashMap<String, StoryReporter>();
        for (String storyPath : storyPaths) {
            reporters.put(storyPath, this.build(storyPath));
        }
        return reporters;
    }

    public StoryReporter reporterFor(String storyPath, Format format) {
        FilePrintStreamFactory factory = this.filePrintStreamFactory(storyPath);
        switch (format) {
            case CONSOLE: {
                return new ConsoleOutput().doReportFailureTrace(this.reportFailureTrace);
            }
            case IDE_CONSOLE: {
                return new IdeOnlyConsoleOutput().doReportFailureTrace(this.reportFailureTrace);
            }
            case TXT: {
                factory.useConfiguration(this.fileConfiguration("txt"));
                return new TxtOutput(factory.createPrintStream()).doReportFailureTrace(this.reportFailureTrace);
            }
            case HTML: {
                factory.useConfiguration(this.fileConfiguration("html"));
                return new HtmlOutput(factory.createPrintStream()).doReportFailureTrace(this.reportFailureTrace);
            }
            case XML: {
                factory.useConfiguration(this.fileConfiguration("xml"));
                return new XmlOutput(factory.createPrintStream()).doReportFailureTrace(this.reportFailureTrace);
            }
            case STATS: {
                factory.useConfiguration(this.fileConfiguration("stats"));
                return new PostStoryStatisticsCollector(factory.createPrintStream());
            }
        }
        throw new UnsupportedReporterFormatException(format);
    }

    protected FilePrintStreamFactory filePrintStreamFactory(String storyPath) {
        return new FilePrintStreamFactory(new StoryLocation(this.codeLocation, storyPath));
    }

    protected FilePrintStreamFactory.FileConfiguration fileConfiguration(String extension) {
        return new FilePrintStreamFactory.FileConfiguration(this.outputDirectory, extension);
    }

    public static class UnsupportedReporterFormatException
    extends RuntimeException {
        public UnsupportedReporterFormatException(Format format) {
            super("StoryReporter format " + (Object)((Object)format) + " not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        CONSOLE,
        IDE_CONSOLE,
        TXT,
        HTML,
        XML,
        STATS;

    }
}

