/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.List;
import java.util.Map;
import org.jbehave.core.failures.StepFailed;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepFailureDecorator
implements StoryReporter {
    private final StoryReporter delegate;
    private StepFailed failure;

    public StepFailureDecorator(StoryReporter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void afterScenario() {
        this.delegate.afterScenario();
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.delegate.afterStory(givenStory);
        if (this.failure != null) {
            throw this.failure;
        }
    }

    @Override
    public void beforeScenario(String title) {
        this.delegate.beforeScenario(title);
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.failure = null;
        this.delegate.beforeStory(story, givenStory);
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.failure = new StepFailed(step, cause);
        this.delegate.failed(step, this.failure);
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.failure = new StepFailed(step, table);
        this.delegate.failedOutcomes(step, table);
    }

    @Override
    public void ignorable(String step) {
        this.delegate.ignorable(step);
    }

    @Override
    public void notPerformed(String step) {
        this.delegate.notPerformed(step);
    }

    @Override
    public void pending(String step) {
        this.delegate.pending(step);
    }

    @Override
    public void successful(String step) {
        this.delegate.successful(step);
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.delegate.givenStories(storyPaths);
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.delegate.beforeExamples(steps, table);
    }

    @Override
    public void example(Map<String, String> tableRow) {
        this.delegate.example(tableRow);
    }

    @Override
    public void afterExamples() {
        this.delegate.afterExamples();
    }

    @Override
    public void dryRun() {
        this.delegate.dryRun();
    }
}

