/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SilentSuccessFilter
implements StoryReporter {
    private final StoryReporter delegate;
    private List<Todo> currentScenario = new ArrayList<Todo>();
    private State scenarioState = State.SILENT;
    private State beforeStoryState = State.SILENT;
    private State afterStoryState = State.SILENT;
    private boolean givenStory;

    public SilentSuccessFilter(StoryReporter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.afterStoryState.report();
    }

    @Override
    public void beforeStory(final Story story, final boolean givenStory) {
        this.givenStory = givenStory;
        this.beforeStoryState = new State(){

            public void report() {
                SilentSuccessFilter.this.delegate.beforeStory(story, givenStory);
                SilentSuccessFilter.this.beforeStoryState = State.SILENT;
            }
        };
    }

    @Override
    public void ignorable(final String step) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.ignorable(step);
            }
        });
    }

    @Override
    public void failed(final String step, final Throwable cause) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.failed(step, cause);
            }
        });
        this.setStateToNoisy();
    }

    @Override
    public void failedOutcomes(final String step, final OutcomesTable table) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.failedOutcomes(step, table);
            }
        });
        this.setStateToNoisy();
    }

    @Override
    public void notPerformed(final String step) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.notPerformed(step);
            }
        });
    }

    @Override
    public void pending(final String step) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.pending(step);
            }
        });
        this.setStateToNoisy();
    }

    private void setStateToNoisy() {
        this.scenarioState = new State(){

            public void report() {
                SilentSuccessFilter.this.beforeStoryState.report();
                for (Todo todo : SilentSuccessFilter.this.currentScenario) {
                    todo.doNow();
                }
                SilentSuccessFilter.this.afterStoryState = new State(){

                    public void report() {
                        SilentSuccessFilter.this.delegate.afterStory(SilentSuccessFilter.this.givenStory);
                        SilentSuccessFilter.this.afterStoryState = State.SILENT;
                    }
                };
                SilentSuccessFilter.this.scenarioState = State.SILENT;
            }
        };
    }

    @Override
    public void successful(final String step) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.successful(step);
            }
        });
    }

    @Override
    public void afterScenario() {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.afterScenario();
            }
        });
        this.scenarioState.report();
    }

    @Override
    public void beforeScenario(final String title) {
        this.currentScenario = new ArrayList<Todo>();
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.beforeScenario(title);
            }
        });
    }

    @Override
    public void givenStories(final List<String> storyPaths) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.givenStories(storyPaths);
            }
        });
    }

    @Override
    public void beforeExamples(final List<String> steps, final ExamplesTable table) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.beforeExamples(steps, table);
            }
        });
    }

    @Override
    public void example(final Map<String, String> tableRow) {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.example(tableRow);
            }
        });
    }

    @Override
    public void afterExamples() {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.afterExamples();
            }
        });
    }

    @Override
    public void dryRun() {
        this.currentScenario.add(new Todo(){

            public void doNow() {
                SilentSuccessFilter.this.delegate.dryRun();
            }
        });
    }

    private static interface State {
        public static final State SILENT = new State(){

            public void report() {
            }
        };

        public void report();
    }

    private static interface Todo {
        public void doNow();
    }
}

