/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.steps.Stepdoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintStreamStepdocReporter
implements StepdocReporter {
    private static final String STEP = "Step: {0} {1}";
    private static final String ALIASES = "Aliases: {0}";
    private static final String METHOD = "Method: {0}";
    private final PrintStream output;
    private final boolean reportMethods;

    public PrintStreamStepdocReporter() {
        this(System.out);
    }

    public PrintStreamStepdocReporter(boolean reportMethods) {
        this(System.out, reportMethods);
    }

    public PrintStreamStepdocReporter(PrintStream output) {
        this(output, false);
    }

    public PrintStreamStepdocReporter(PrintStream output, boolean reportMethods) {
        this.output = output;
        this.reportMethods = reportMethods;
    }

    @Override
    public void report(List<Stepdoc> stepdocs) {
        for (Stepdoc stepdoc : stepdocs) {
            this.output.println(MessageFormat.format(STEP, stepdoc.getAnnotation().getSimpleName(), stepdoc.getPattern()));
            if (stepdoc.getAliasPatterns().size() > 0) {
                this.output.println(MessageFormat.format(ALIASES, stepdoc.getAliasPatterns()));
            }
            if (!this.reportMethods) continue;
            this.output.println(MessageFormat.format(METHOD, stepdoc.getMethod()));
        }
    }
}

