/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrintStreamOutput
implements StoryReporter {
    private static final String EMPTY = "";
    private final Format format;
    private final PrintStream output;
    private final Properties outputPatterns;
    private final Keywords keywords;
    private boolean reportFailureTrace;
    private Throwable cause;

    protected PrintStreamOutput(Format format, PrintStream output, Properties outputPatterns, Keywords keywords, boolean reportFailureTrace) {
        this.format = format;
        this.output = output;
        this.outputPatterns = outputPatterns;
        this.keywords = keywords;
        this.reportFailureTrace = reportFailureTrace;
    }

    @Override
    public void successful(String step) {
        this.print(this.format("successful", "{0}\n", step));
    }

    @Override
    public void ignorable(String step) {
        this.print(this.format("ignorable", "{0}\n", step));
    }

    @Override
    public void pending(String step) {
        this.print(this.format("pending", "{0} ({1})\n", step, this.keywords.pending()));
    }

    @Override
    public void notPerformed(String step) {
        this.print(this.format("notPerformed", "{0} ({1})\n", step, this.keywords.notPerformed()));
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.cause = cause;
        this.print(this.format("failed", "{0} ({1})\n({2})\n", step, this.keywords.failed(), cause));
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.failed(step, table.failureCause());
        this.print(table);
    }

    private void print(OutcomesTable table) {
        this.print(this.format("outcomesTableStart", "\n", new Object[0]));
        List<OutcomesTable.Outcome<?>> rows = table.getOutcomes();
        this.print(this.format("outcomesTableHeadStart", "|", new Object[0]));
        for (String string : table.getOutcomeFields()) {
            this.print(this.format("outcomesTableHeadCell", "{0}|", string));
        }
        this.print(this.format("outcomesTableHeadEnd", "\n", new Object[0]));
        this.print(this.format("outcomesTableBodyStart", EMPTY, new Object[0]));
        for (OutcomesTable.Outcome outcome : rows) {
            this.print(this.format("outcomesTableRowStart", "|", outcome.isVerified() ? "verified" : "notVerified"));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.getDescription()));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.getValue()));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.getMatcher()));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.isVerified()));
            this.print(this.format("outcomesTableRowEnd", "\n", new Object[0]));
        }
        this.print(this.format("outcomesTableBodyEnd", "\n", new Object[0]));
        this.print(this.format("outcomesTableEnd", "\n", new Object[0]));
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.print(this.format("beforeStory", "{0}\n({1})\n", story.getDescription().asString(), story.getPath()));
        if (!story.getNarrative().isEmpty()) {
            Narrative narrative = story.getNarrative();
            this.print(this.format("narrative", "{0}\n{1} {2}\n{3} {4}\n{5} {6}\n", this.keywords.narrative(), this.keywords.inOrderTo(), narrative.inOrderTo(), this.keywords.asA(), narrative.asA(), this.keywords.iWantTo(), narrative.iWantTo()));
        }
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.print(this.format("afterStory", "\n", new Object[0]));
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.print(this.format("givenStories", "{0} {1}\n", this.keywords.givenStories(), storyPaths));
    }

    @Override
    public void beforeScenario(String title) {
        this.cause = null;
        this.print(this.format("beforeScenario", "{0} {1}\n", this.keywords.scenario(), title));
    }

    @Override
    public void afterScenario() {
        if (this.cause != null && this.reportFailureTrace) {
            this.print(this.format("afterScenarioWithFailure", "\n{0}\n", this.stackTrace(this.cause)));
        } else {
            this.print(this.format("afterScenario", "\n", new Object[0]));
        }
    }

    private String stackTrace(Throwable cause) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        cause.printStackTrace(new PrintStream(out));
        return out.toString();
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.print(this.format("beforeExamples", "{0}\n", this.keywords.examplesTable()));
        for (String step : steps) {
            this.print(this.format("examplesStep", "{0}\n", step));
        }
        this.print(table);
    }

    private void print(ExamplesTable table) {
        this.print(this.format("examplesTableStart", "\n", new Object[0]));
        List<Map<String, String>> rows = table.getRows();
        List<String> headers = table.getHeaders();
        this.print(this.format("examplesTableHeadStart", "|", new Object[0]));
        for (String string : headers) {
            this.print(this.format("examplesTableHeadCell", "{0}|", string));
        }
        this.print(this.format("examplesTableHeadEnd", "\n", new Object[0]));
        this.print(this.format("examplesTableBodyStart", EMPTY, new Object[0]));
        for (Map map : rows) {
            this.print(this.format("examplesTableRowStart", "|", new Object[0]));
            for (String header : headers) {
                this.print(this.format("examplesTableCell", "{0}|", map.get(header)));
            }
            this.print(this.format("examplesTableRowEnd", "\n", new Object[0]));
        }
        this.print(this.format("examplesTableBodyEnd", "\n", new Object[0]));
        this.print(this.format("examplesTableEnd", "\n", new Object[0]));
    }

    @Override
    public void example(Map<String, String> tableRow) {
        this.print(this.format("example", "\n{0} {1}\n", this.keywords.examplesTableRow(), tableRow));
    }

    @Override
    public void afterExamples() {
        this.print(this.format("afterExamples", "\n", new Object[0]));
    }

    @Override
    public void dryRun() {
        this.print(this.format("dryRun", "{0}\n", this.keywords.dryRun()));
    }

    protected String format(String key, String defaultPattern, Object ... args) {
        return MessageFormat.format(this.lookupPattern(key, this.escape(defaultPattern)), this.escapeAll(args));
    }

    private String escape(String defaultPattern) {
        return (String)this.escapeAll(defaultPattern)[0];
    }

    private Object[] escapeAll(Object ... args) {
        return this.escape(this.format, args);
    }

    protected Object[] escape(final Format format, Object ... args) {
        Transformer escapingTransformer = new Transformer(){

            public Object transform(Object object) {
                switch (format) {
                    case HTML: {
                        return StringEscapeUtils.escapeHtml((String)this.asString(object));
                    }
                    case XML: {
                        return StringEscapeUtils.escapeXml((String)this.asString(object));
                    }
                }
                return object;
            }

            private String asString(Object object) {
                return object != null ? object.toString() : PrintStreamOutput.EMPTY;
            }
        };
        List<Object> list = Arrays.asList(ArrayUtils.clone((Object[])args));
        CollectionUtils.transform(list, (Transformer)escapingTransformer);
        return list.toArray();
    }

    protected String lookupPattern(String key, String defaultPattern) {
        if (this.outputPatterns.containsKey(key)) {
            return this.outputPatterns.getProperty(key);
        }
        return defaultPattern;
    }

    public PrintStreamOutput doReportFailureTrace(boolean reportFailureTrace) {
        this.reportFailureTrace = reportFailureTrace;
        return this;
    }

    protected void print(String text) {
        this.output.print(text.replace(this.format("\uff5f", "\uff5f", new Object[0]), this.format("parameterValueStart", EMPTY, new Object[0])).replace(this.format("\uff60", "\uff60", new Object[0]), this.format("parameterValueEnd", EMPTY, new Object[0])).replace(this.format("NL", "NL", new Object[0]), this.format("parameterValueNewline", "\n", new Object[0])));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        TXT,
        HTML,
        XML;

    }
}

