/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import org.jbehave.core.reporters.CandidateStepReporter;
import org.jbehave.core.steps.CandidateStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintStreamCandidateStepReporter
implements CandidateStepReporter {
    private static final String STEP_MATCHED_BY = "Step ''{0}'' is matched by annotated methods:";
    private static final String STEP_NOT_MATCHED = "Step ''{0}'' is not matched by any method";
    private PrintStream output;

    public PrintStreamCandidateStepReporter() {
        this(System.out);
    }

    public PrintStreamCandidateStepReporter(PrintStream output) {
        this.output = output;
    }

    @Override
    public void candidateStepsMatching(String stepAsString, List<CandidateStep> candidateSteps, List<Object> stepsInstances) {
        if (candidateSteps.size() > 0) {
            this.output.println(MessageFormat.format(STEP_MATCHED_BY, stepAsString));
            for (CandidateStep candidateStep : candidateSteps) {
                Method method = candidateStep.getMethod();
                for (Annotation annotation : method.getAnnotations()) {
                    this.output.println(annotation);
                }
                this.output.println(method);
            }
        } else {
            this.output.println(MessageFormat.format(STEP_NOT_MATCHED, stepAsString));
        }
        if (stepsInstances.size() > 0) {
            this.output.println("from steps instances:");
            for (Object stepsInstance : stepsInstances) {
                this.output.println(stepsInstance.getClass().getName());
            }
        } else {
            this.output.println("as no steps instances are provided");
        }
    }
}

