/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostStoryStatisticsCollector
implements StoryReporter {
    private final OutputStream output;
    private final Map<String, Integer> data = new HashMap<String, Integer>();
    private final List<String> events = Arrays.asList("steps", "stepsSuccessful", "stepsIgnorable", "stepsPending", "stepsNotPerformed", "stepsFailed", "scenarios", "scenariosFailed", "givenStories", "examples");
    private Throwable cause;
    private OutcomesTable outcomesFailed;

    public PostStoryStatisticsCollector(OutputStream output) {
        this.output = output;
    }

    @Override
    public void successful(String step) {
        this.count("steps");
        this.count("stepsSuccessful");
    }

    @Override
    public void ignorable(String step) {
        this.count("steps");
        this.count("stepsIgnorable");
    }

    @Override
    public void pending(String step) {
        this.count("steps");
        this.count("stepsPending");
    }

    @Override
    public void notPerformed(String step) {
        this.count("steps");
        this.count("stepsNotPerformed");
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.cause = cause;
        this.count("steps");
        this.count("stepsFailed");
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.outcomesFailed = table;
        this.count("steps");
        this.count("stepsFailed");
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.resetData();
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.writeData();
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.count("givenStories");
    }

    @Override
    public void beforeScenario(String title) {
        this.cause = null;
        this.outcomesFailed = null;
    }

    @Override
    public void afterScenario() {
        this.count("scenarios");
        if (this.cause != null || this.outcomesFailed != null) {
            this.count("scenariosFailed");
        }
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
    }

    @Override
    public void example(Map<String, String> tableRow) {
        this.count("examples");
    }

    @Override
    public void afterExamples() {
    }

    @Override
    public void dryRun() {
    }

    private void count(String event) {
        Integer count = this.data.get(event);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        this.data.put(event, count);
    }

    private void writeData() {
        Properties p = new Properties();
        for (String event : this.data.keySet()) {
            p.setProperty(event, this.data.get(event).toString());
        }
        try {
            p.store(this.output, this.getClass().getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void resetData() {
        this.data.clear();
        for (String event : this.events) {
            this.data.put(event, 0);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.output).append(this.data).toString();
    }
}

