/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.reporters.TxtOutput;

public class IdeOnlyConsoleOutput
extends TxtOutput {
    public IdeOnlyConsoleOutput() {
        super(IdeOnlyConsoleOutput.output());
    }

    public IdeOnlyConsoleOutput(Properties outputPatterns) {
        super(IdeOnlyConsoleOutput.output(), outputPatterns);
    }

    public IdeOnlyConsoleOutput(Properties outputPatterns, Keywords keywords, boolean reportErrors) {
        super(IdeOnlyConsoleOutput.output(), outputPatterns, keywords, reportErrors);
    }

    public static PrintStream output() {
        if (IdeOnlyConsoleOutput.inIDE()) {
            return System.out;
        }
        return new PrintStream(new ByteArrayOutputStream());
    }

    private static boolean inIDE() {
        List<String> idePackages = Arrays.asList("com.intellij", "org.eclipse");
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            for (String idePackage : idePackages) {
                if (!ste.getClassName().startsWith(idePackage)) continue;
                return true;
            }
        }
        return false;
    }
}

