/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jbehave.core.reporters.ViewGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerViewGenerator
implements ViewGenerator {
    private final Configuration configuration;
    private Properties resources;
    private List<Report> reports = new ArrayList<Report>();

    public FreemarkerViewGenerator() {
        this.configuration = this.configure();
    }

    public static Properties defaultResources() {
        Properties resources = new Properties();
        resources.setProperty("index", "ftl/jbehave-reports-index.ftl");
        resources.setProperty("decorated", "ftl/jbehave-report-decorated.ftl");
        resources.setProperty("nonDecorated", "ftl/jbehave-report-non-decorated.ftl");
        resources.setProperty("decorateNonHtml", "true");
        resources.setProperty("defaultFormats", "stats");
        resources.setProperty("viewDirectory", "view");
        return resources;
    }

    private Properties mergeWithDefault(Properties resources) {
        Properties merged = FreemarkerViewGenerator.defaultResources();
        merged.putAll((Map<?, ?>)resources);
        return merged;
    }

    @Override
    public void generateView(File outputDirectory, List<String> formats, Properties resources) {
        this.resources = this.mergeWithDefault(resources);
        this.createIndex(outputDirectory, formats);
    }

    @Override
    public int countStories() {
        return this.reports.size();
    }

    @Override
    public int countScenarios() {
        return this.count("scenarios", this.reports);
    }

    @Override
    public int countFailedScenarios() {
        return this.count("scenariosFailed", this.reports);
    }

    private int count(String event, List<Report> reports) {
        int count = 0;
        for (Report report : reports) {
            Properties stats = report.asProperties("stats");
            if (stats == null || !stats.containsKey(event)) continue;
            int failed = Integer.parseInt((String)stats.get(event));
            count += failed;
        }
        return count;
    }

    private void createIndex(File outputDirectory, List<String> formats) {
        String outputName = this.templateResource("viewDirectory") + "/index.html";
        String index = this.templateResource("index");
        List<String> mergedFormats = this.mergeWithDefaults(formats);
        this.reports = this.toReports(this.indexedReportFiles(outputDirectory, outputName, mergedFormats));
        Map<String, Object> dataModel = this.newDataModel();
        dataModel.put("reports", this.reports);
        dataModel.put("date", new Date());
        this.write(outputDirectory, outputName, index, dataModel);
    }

    private List<String> mergeWithDefaults(List<String> formats) {
        ArrayList<String> merged = new ArrayList<String>();
        merged.addAll(Arrays.asList(this.templateResource("defaultFormats").split(",")));
        merged.addAll(formats);
        return merged;
    }

    private SortedMap<String, List<File>> indexedReportFiles(File outputDirectory, final String outputName, final List<String> formats) {
        String[] fileNames;
        TreeMap<String, List<File>> reports = new TreeMap<String, List<File>>();
        if (outputDirectory == null || !outputDirectory.exists()) {
            return reports;
        }
        for (String fileName : fileNames = outputDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equals(outputName) && this.hasFormats(name, formats);
            }

            private boolean hasFormats(String name, List<String> formats2) {
                for (String format : formats2) {
                    if (!name.endsWith(format)) continue;
                    return true;
                }
                return false;
            }
        })) {
            String name = FilenameUtils.getBaseName((String)fileName);
            ArrayList<File> filesByName = (ArrayList<File>)reports.get(name);
            if (filesByName == null) {
                filesByName = new ArrayList<File>();
                reports.put(name, filesByName);
            }
            filesByName.add(new File(outputDirectory, fileName));
        }
        return reports;
    }

    private List<Report> toReports(Map<String, List<File>> reportFiles) {
        try {
            String decoratedTemplate = this.templateResource("decorated");
            String nonDecoratedTemplate = this.templateResource("nonDecorated");
            String viewDirectory = this.templateResource("viewDirectory");
            boolean decorateNonHtml = Boolean.valueOf(this.templateResource("decorateNonHtml"));
            ArrayList<Report> reports = new ArrayList<Report>();
            for (String name : reportFiles.keySet()) {
                HashMap<String, File> filesByFormat = new HashMap<String, File>();
                for (File file : reportFiles.get(name)) {
                    String fileName = file.getName();
                    String format = FilenameUtils.getExtension((String)fileName);
                    Map<String, Object> dataModel = this.newDataModel();
                    dataModel.put("name", name);
                    dataModel.put("body", IOUtils.toString((Reader)new FileReader(file)));
                    dataModel.put("format", format);
                    File outputDirectory = file.getParentFile();
                    String outputName = viewDirectory + "/" + fileName;
                    String template = decoratedTemplate;
                    if (!format.equals("html")) {
                        if (decorateNonHtml) {
                            outputName = outputName + ".html";
                        } else {
                            template = nonDecoratedTemplate;
                        }
                    }
                    File written = this.write(outputDirectory, outputName, template, dataModel);
                    filesByFormat.put(format, written);
                }
                reports.add(new Report(name, filesByFormat));
            }
            return reports;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File write(File outputDirectory, String outputName, String resource, Map<String, Object> dataModel) {
        try {
            File file = new File(outputDirectory, outputName);
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            this.process(resource, dataModel, writer);
            return file;
        }
        catch (Exception e) {
            throw new ViewGenerationFailedForTemplate(resource, e);
        }
    }

    private Configuration configure() {
        Configuration configuration = new Configuration();
        configuration.setClassForTemplateLoading(FreemarkerViewGenerator.class, "/");
        configuration.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        return configuration;
    }

    private void process(String resource, Map<String, Object> dataModel, Writer writer) throws TemplateException, IOException {
        Template template = this.configuration.getTemplate(resource);
        template.process(dataModel, writer);
    }

    private String templateResource(String format) {
        String resource = this.resources.getProperty(format);
        if (resource == null) {
            throw new ViewTemplateNotFoundForFormat(format);
        }
        return resource;
    }

    private Map<String, Object> newDataModel() {
        return new HashMap<String, Object>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Report {
        private final String name;
        private final Map<String, File> filesByFormat;

        public Report(String name, Map<String, File> filesByFormat) {
            this.name = name;
            this.filesByFormat = filesByFormat;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, File> getFilesByFormat() {
            return this.filesByFormat;
        }

        public Properties asProperties(String format) {
            Properties p = new Properties();
            File stats = this.filesByFormat.get(format);
            if (stats == null) {
                return p;
            }
            try {
                p.load(new FileInputStream(stats));
            }
            catch (IOException e) {
                // empty catch block
            }
            return p;
        }
    }

    public static class ViewTemplateNotFoundForFormat
    extends RuntimeException {
        public ViewTemplateNotFoundForFormat(String format) {
            super(format);
        }
    }

    public static class ViewGenerationFailedForTemplate
    extends RuntimeException {
        public ViewGenerationFailedForTemplate(String resource, Exception cause) {
            super(resource, cause);
        }
    }
}

