/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.io.StoryLocation;
import org.jbehave.core.reporters.PrintStreamFactory;

public class FilePrintStreamFactory
implements PrintStreamFactory {
    private final StoryLocation storyLocation;
    private FileConfiguration configuration;
    private File outputFile;

    public FilePrintStreamFactory(StoryLocation storyLocation) {
        this(storyLocation, new FileConfiguration());
    }

    public FilePrintStreamFactory(StoryLocation storyLocation, FileConfiguration configuration) {
        this.storyLocation = storyLocation;
        this.configuration = configuration;
        this.outputFile = this.outputFile();
    }

    public PrintStream createPrintStream() {
        try {
            this.outputFile.getParentFile().mkdirs();
            return new FilePrintStream(this.outputFile, false);
        }
        catch (IOException e) {
            throw new PrintStreamCreationFailedException(this.outputFile, e);
        }
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void useConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
        this.outputFile = this.outputFile();
    }

    protected File outputFile() {
        return new File(this.outputDirectory(), this.outputName());
    }

    protected File outputDirectory() {
        File codeLocationParent = new File(this.storyLocation.getCodeLocation().getFile()).getParentFile();
        return new File(codeLocationParent, this.configuration.getOutputDirectory());
    }

    protected String outputName() {
        String storyName = this.storyLocation.getName().replace('/', '.');
        if (storyName.startsWith(".")) {
            storyName = storyName.substring(1);
        }
        String name = this.stripPackage(storyName);
        return name + "." + this.configuration.getExtension();
    }

    private String stripPackage(String name) {
        if (name.lastIndexOf(".") != -1) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    private class PrintStreamCreationFailedException
    extends RuntimeException {
        public PrintStreamCreationFailedException(File file, IOException cause) {
            super("Failed to create print stream for file " + file, cause);
        }
    }

    public static class FileConfiguration {
        public static final String OUTPUT_DIRECTORY = "jbehave-reports";
        public static final String HTML = "html";
        private final String outputDirectory;
        private final String extension;

        public FileConfiguration() {
            this(HTML);
        }

        public FileConfiguration(String extension) {
            this(OUTPUT_DIRECTORY, extension);
        }

        public FileConfiguration(String outputDirectory, String extension) {
            this.outputDirectory = outputDirectory;
            this.extension = extension;
        }

        public String getOutputDirectory() {
            return this.outputDirectory;
        }

        public String getExtension() {
            return this.extension;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class FilePrintStream
    extends PrintStream {
        private final File outputFile;
        private final boolean append;

        public FilePrintStream(File outputFile, boolean append) throws FileNotFoundException {
            super(new FileOutputStream(outputFile, append));
            this.outputFile = outputFile;
            this.append = append;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.outputFile).append(this.append).toString();
        }
    }
}

