/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.parsers.StoryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexStoryParser
implements StoryParser {
    private static final String NONE = "";
    private static final String COMMA = ",";
    private final Keywords keywords;
    private String storyPath;

    public RegexStoryParser() {
        this(new LocalizedKeywords());
    }

    public RegexStoryParser(Keywords keywords) {
        this.keywords = keywords;
    }

    @Override
    public Story parseStory(String storyAsText) {
        return this.parseStory(storyAsText, null);
    }

    @Override
    public Story parseStory(String storyAsText, String storyPath) {
        this.storyPath = storyPath;
        Description description = this.parseDescriptionFrom(storyAsText);
        Narrative narrative = this.parseNarrativeFrom(storyAsText);
        List<Scenario> scenarios = this.parseScenariosFrom(storyAsText);
        return new Story(description, narrative, storyPath, scenarios);
    }

    private Description parseDescriptionFrom(String storyAsText) {
        String concatenatedKeywords = this.concatenateWithOr(this.keywords.narrative(), this.keywords.scenario());
        Pattern findDescription = Pattern.compile("(.*?)(" + concatenatedKeywords + ").*", 32);
        Matcher findingDescription = findDescription.matcher(storyAsText);
        if (findingDescription.matches()) {
            return new Description(findingDescription.group(1).trim());
        }
        return Description.EMPTY;
    }

    private Narrative parseNarrativeFrom(String storyAsText) {
        Pattern findNarrative = Pattern.compile(".*" + this.keywords.narrative() + "(.*?)\\s*(" + this.keywords.scenario() + ").*", 32);
        Matcher findingNarrative = findNarrative.matcher(storyAsText);
        if (findingNarrative.matches()) {
            String narrative = findingNarrative.group(1).trim();
            return this.createNarrative(narrative);
        }
        return Narrative.EMPTY;
    }

    private Narrative createNarrative(String narrative) {
        Pattern findElements = Pattern.compile(".*" + this.keywords.inOrderTo() + "(.*)\\s*" + this.keywords.asA() + "(.*)\\s*" + this.keywords.iWantTo() + "(.*)", 32);
        Matcher findingElements = findElements.matcher(narrative);
        if (findingElements.matches()) {
            String inOrderTo = findingElements.group(1).trim();
            String asA = findingElements.group(2).trim();
            String iWantTo = findingElements.group(3).trim();
            return new Narrative(inOrderTo, asA, iWantTo);
        }
        return Narrative.EMPTY;
    }

    private List<Scenario> parseScenariosFrom(String storyAsText) {
        ArrayList<Scenario> parsed = new ArrayList<Scenario>();
        List<String> scenariosAsText = this.splitScenarios(storyAsText);
        for (String scenarioAsText : scenariosAsText) {
            parsed.add(this.parseScenario(scenarioAsText));
        }
        return parsed;
    }

    private Scenario parseScenario(String scenarioAsText) {
        String title = this.findTitle(scenarioAsText);
        ExamplesTable table = this.findTable(scenarioAsText);
        List<String> givenStoryPaths = this.findGivenStoryPaths(scenarioAsText);
        List<String> steps = this.findSteps(scenarioAsText);
        return new Scenario(title, givenStoryPaths, table, steps);
    }

    private String findTitle(String scenarioAsText) {
        Matcher findingTitle = this.patternToPullScenarioTitleIntoGroupOne().matcher(scenarioAsText);
        return findingTitle.find() ? findingTitle.group(1).trim() : NONE;
    }

    private ExamplesTable findTable(String scenarioAsText) {
        Matcher findingTable = this.patternToPullExamplesTableIntoGroupOne().matcher(scenarioAsText);
        String table = findingTable.find() ? findingTable.group(1).trim() : NONE;
        return new ExamplesTable(table, this.keywords.examplesTableHeaderSeparator(), this.keywords.examplesTableValueSeparator());
    }

    private List<String> findGivenStoryPaths(String scenarioAsText) {
        Matcher findingGivenStories = this.patternToPullGivenStoriesIntoGroupOne().matcher(scenarioAsText);
        String givenStories = findingGivenStories.find() ? findingGivenStories.group(1).trim() : NONE;
        ArrayList<String> givenStoryPaths = new ArrayList<String>();
        for (String storyPath : givenStories.split(COMMA)) {
            String trimmed = storyPath.trim();
            if (trimmed.length() <= 0) continue;
            givenStoryPaths.add(trimmed);
        }
        return givenStoryPaths;
    }

    private List<String> findSteps(String scenarioAsText) {
        Matcher matcher = this.patternToPullOutSteps().matcher(scenarioAsText);
        ArrayList<String> steps = new ArrayList<String>();
        int startAt = 0;
        while (matcher.find(startAt)) {
            steps.add(matcher.group(1));
            startAt = matcher.start(4);
        }
        return steps;
    }

    protected List<String> splitScenarios(String storyAsText) {
        return this.splitScenariosWithKeyword(storyAsText);
    }

    protected List<String> splitScenariosWithKeyword(String storyAsText) {
        ArrayList<String> scenarios = new ArrayList<String>();
        String scenarioKeyword = this.keywords.scenario();
        String allScenarios = null;
        int keywordIndex = storyAsText.indexOf(scenarioKeyword);
        allScenarios = keywordIndex != -1 ? storyAsText.substring(keywordIndex) : storyAsText;
        for (String scenario : allScenarios.split(scenarioKeyword)) {
            if (scenario.trim().length() <= 0) continue;
            scenarios.add(scenarioKeyword + scenario);
        }
        return scenarios;
    }

    protected List<String> splitScenariosWithPattern(String storyAsText) {
        Pattern scenarioSplitter = this.patternToPullScenariosIntoGroupFour();
        Matcher matcher = scenarioSplitter.matcher(storyAsText);
        int startAt = 0;
        ArrayList<String> scenarios = new ArrayList<String>();
        try {
            if (matcher.matches()) {
                while (matcher.find(startAt)) {
                    scenarios.add(matcher.group(1));
                    startAt = matcher.start(4);
                }
            } else {
                scenarios.add(storyAsText);
            }
        }
        catch (StackOverflowError e) {
            String message = "Failed to parse story (see http://jbehave.org/documentation/known-issues/regex-stack-overflow-errors): " + (this.storyPath != null ? this.storyPath : storyAsText);
            throw new InvalidPatternException(message, e);
        }
        return scenarios;
    }

    private Pattern patternToPullScenariosIntoGroupFour() {
        String scenario = this.keywords.scenario();
        return Pattern.compile(".*?((" + scenario + ") (.|\\s)*?)\\s*(\\Z|" + scenario + ").*", 32);
    }

    private Pattern patternToPullGivenStoriesIntoGroupOne() {
        String givenScenarios = this.keywords.givenStories();
        String concatenatedKeywords = this.concatenateWithOr(this.keywords.given(), this.keywords.when(), this.keywords.then(), this.keywords.others());
        return Pattern.compile(".*" + givenScenarios + "((.|\\n)*?)\\s*(" + concatenatedKeywords + ").*");
    }

    private Pattern patternToPullExamplesTableIntoGroupOne() {
        String table = this.keywords.examplesTable();
        return Pattern.compile(".*" + table + "\\s*(.*)", 32);
    }

    private Pattern patternToPullScenarioTitleIntoGroupOne() {
        String scenario = this.keywords.scenario();
        String concatenatedKeywords = this.concatenateWithOr(this.keywords.given(), this.keywords.when(), this.keywords.then(), this.keywords.others());
        return Pattern.compile(scenario + "((.|\\n)*?)\\s*(" + concatenatedKeywords + ").*");
    }

    private String concatenateWithOr(String given, String when, String then, String[] others) {
        return this.concatenateWithOr(false, given, when, then, others);
    }

    private String concatenateWithSpaceOr(String given, String when, String then, String[] others) {
        return this.concatenateWithOr(true, given, when, then, others);
    }

    private String concatenateWithOr(boolean usingSpace, String given, String when, String then, String[] others) {
        StringBuilder builder = new StringBuilder();
        builder.append(given).append(usingSpace ? "\\s|" : "|");
        builder.append(when).append(usingSpace ? "\\s|" : "|");
        builder.append(then).append(usingSpace ? "\\s|" : "|");
        builder.append(usingSpace ? this.concatenateWithSpaceOr(others) : this.concatenateWithOr(others));
        return builder.toString();
    }

    private String concatenateWithOr(String ... keywords) {
        return this.concatenateWithOr(false, new StringBuilder(), keywords);
    }

    private String concatenateWithSpaceOr(String ... keywords) {
        return this.concatenateWithOr(true, new StringBuilder(), keywords);
    }

    private String concatenateWithOr(boolean usingSpace, StringBuilder builder, String[] keywords) {
        for (String other : keywords) {
            builder.append(other).append(usingSpace ? "\\s|" : "|");
        }
        String result = builder.toString();
        return result.substring(0, result.length() - 1);
    }

    private Pattern patternToPullOutSteps() {
        String givenWhenThen = this.concatenateWithOr(this.keywords.given(), this.keywords.when(), this.keywords.then(), this.keywords.others());
        String givenWhenThenSpaced = this.concatenateWithSpaceOr(this.keywords.given(), this.keywords.when(), this.keywords.then(), this.keywords.others());
        String scenario = this.keywords.scenario();
        String table = this.keywords.examplesTable();
        return Pattern.compile("((" + givenWhenThen + ") (.)*?)\\s*(\\Z|" + givenWhenThenSpaced + "|" + scenario + "|" + table + ")", 32);
    }

    public static class InvalidPatternException
    extends RuntimeException {
        public InvalidPatternException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

