/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.parsers.RegexStepMatcher;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.parsers.StepPatternParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexPrefixCapturingPatternParser
implements StepPatternParser {
    private final String prefix;
    private final String anyWordBeginningWithThePrefix;

    public RegexPrefixCapturingPatternParser() {
        this("$");
    }

    public RegexPrefixCapturingPatternParser(String prefix) {
        this.prefix = prefix;
        this.anyWordBeginningWithThePrefix = "(\\" + prefix + "\\w*)(\\W|\\Z)";
    }

    @Override
    public StepMatcher parseStep(String stepPattern) {
        return new RegexStepMatcher(this.buildPattern(stepPattern), this.extractParameterNames(stepPattern));
    }

    private Pattern buildPattern(String stepPattern) {
        String matchThisButLeaveBrackets = this.escapeRegexPunctuation(stepPattern);
        List<Replacement> replacements = this.findArgumentsToReplace(matchThisButLeaveBrackets);
        String patternToMatchAgainst = this.replaceIdentifiedArgsWithCapture(matchThisButLeaveBrackets, replacements);
        String matchThisButIgnoreWhitespace = this.anyWhitespaceWillDo(patternToMatchAgainst);
        return Pattern.compile(matchThisButIgnoreWhitespace, 32);
    }

    private String anyWhitespaceWillDo(String matchThis) {
        return matchThis.replaceAll("\\s+", "\\\\s+");
    }

    private String[] extractParameterNames(String stepPattern) {
        ArrayList<String> names = new ArrayList<String>();
        for (Replacement replacement : this.findArgumentsToReplace(stepPattern)) {
            names.add(replacement.name);
        }
        return names.toArray(new String[names.size()]);
    }

    private List<Replacement> findArgumentsToReplace(String matchThisButLeaveBrackets) {
        Matcher findingAllTheDollarWords = Pattern.compile(this.anyWordBeginningWithThePrefix, 32).matcher(matchThisButLeaveBrackets);
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        while (findingAllTheDollarWords.find()) {
            replacements.add(new Replacement(matchThisButLeaveBrackets, findingAllTheDollarWords.start(), findingAllTheDollarWords.end(), findingAllTheDollarWords.group(2)));
        }
        return replacements;
    }

    private String replaceIdentifiedArgsWithCapture(String escapedMatch, List<Replacement> replacements) {
        String matchTemp = escapedMatch;
        for (int i = replacements.size(); i > 0; --i) {
            String start = matchTemp.substring(0, replacements.get(i - 1).start);
            String end = matchTemp.substring(replacements.get(i - 1).end);
            String whitespaceIfAny = replacements.get(i - 1).whitespaceIfAny;
            matchTemp = start + "(.*)" + whitespaceIfAny + end;
        }
        return matchTemp;
    }

    private String escapeRegexPunctuation(String matchThis) {
        String escapedMatch = matchThis.replaceAll("([\\[\\]\\{\\}\\?\\^\\.\\*\\(\\)\\+\\\\])", "\\\\$1");
        return escapedMatch;
    }

    private class Replacement {
        private final int start;
        private final int end;
        private final String whitespaceIfAny;
        private final String name;

        public Replacement(String pattern, int start, int end, String whitespaceIfAny) {
            this.start = start;
            this.end = end;
            this.whitespaceIfAny = whitespaceIfAny;
            this.name = pattern.substring(start + RegexPrefixCapturingPatternParser.this.prefix.length(), end).trim();
        }
    }
}

