/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Story {
    private final Description description;
    private final Narrative narrative;
    private final List<Scenario> scenarios;
    private String name = "Story";
    private String path = "";

    public Story(Scenario ... scenarios) {
        this(Arrays.asList(scenarios));
    }

    public Story(List<Scenario> scenarios) {
        this(Description.EMPTY, Narrative.EMPTY, scenarios);
    }

    public Story(Description description, Scenario ... scenarios) {
        this(description, Narrative.EMPTY, Arrays.asList(scenarios));
    }

    public Story(Description description, Narrative narrative, List<Scenario> scenarios) {
        this(description, narrative, "", scenarios);
    }

    public Story(Description description, Narrative narrative, String path, List<Scenario> scenarios) {
        this.description = description;
        this.narrative = narrative;
        this.path = path;
        this.scenarios = scenarios;
    }

    public Description getDescription() {
        return this.description;
    }

    public Narrative getNarrative() {
        return this.narrative;
    }

    public List<Scenario> getScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    public String getName() {
        return this.name;
    }

    public void namedAs(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path != null ? this.path : "";
    }
}

