/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbehave.core.model.ExamplesTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scenario {
    private final String title;
    private final List<String> givenStoryPaths;
    private final List<String> steps;
    private final ExamplesTable table;

    public Scenario() {
        this("");
    }

    public Scenario(String title) {
        this(title, new ArrayList<String>());
    }

    public Scenario(List<String> steps) {
        this("", steps);
    }

    public Scenario(String title, List<String> steps) {
        this(title, new ArrayList<String>(), new ExamplesTable(""), steps);
    }

    public Scenario(String title, List<String> givenStoryPaths, List<String> steps) {
        this(title, givenStoryPaths, new ExamplesTable(""), steps);
    }

    public Scenario(String title, ExamplesTable table, String ... steps) {
        this(title, new ArrayList<String>(), table, Arrays.asList(steps));
    }

    public Scenario(String title, List<String> givenStoryPaths, ExamplesTable table, List<String> steps) {
        this.title = title;
        this.givenStoryPaths = givenStoryPaths;
        this.steps = steps;
        this.table = table;
    }

    public List<String> getGivenStoryPaths() {
        return this.givenStoryPaths;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public String getTitle() {
        return this.title;
    }

    public ExamplesTable getTable() {
        return this.table;
    }
}

