/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamplesTable {
    private static final String NEWLINE = "\n";
    private static final String HEADER_SEPARATOR = "|";
    private static final String VALUE_SEPARATOR = "|";
    private final List<Map<String, String>> data = new ArrayList<Map<String, String>>();
    private final String tableAsString;
    private final String headerSeparator;
    private final String valueSeparator;
    private final List<String> headers = new ArrayList<String>();

    public ExamplesTable(String tableAsString) {
        this(tableAsString, "|", "|");
    }

    public ExamplesTable(String tableAsString, String headerSeparator, String valueSeparator) {
        this.tableAsString = tableAsString;
        this.headerSeparator = headerSeparator;
        this.valueSeparator = valueSeparator;
        this.parse();
    }

    private void parse() {
        this.data.clear();
        String[] rows = this.tableAsString.trim().split(NEWLINE);
        this.headers.clear();
        for (int row = 0; row < rows.length; ++row) {
            List<String> columns;
            if (row == 0) {
                columns = this.columnsFor(rows[row], this.headerSeparator);
                this.headers.addAll(columns);
                continue;
            }
            columns = this.columnsFor(rows[row], this.valueSeparator);
            HashMap<String, String> map = new HashMap<String, String>();
            for (int column = 0; column < columns.size(); ++column) {
                map.put(this.headers.get(column), columns.get(column));
            }
            this.data.add(map);
        }
    }

    private List<String> columnsFor(String row, String separator) {
        ArrayList<String> columns = new ArrayList<String>();
        for (String column : row.split(this.buildRegex(separator))) {
            columns.add(column.trim());
        }
        int size = columns.size();
        if (size > 0) {
            columns.remove(0);
        }
        return columns;
    }

    private String buildRegex(String separator) {
        char[] chars = separator.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (char c : chars) {
            sb.append("\\").append(c);
        }
        return sb.toString();
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getRow(int row) {
        return this.data.get(row);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public List<Map<String, String>> getRows() {
        return this.data;
    }

    public String getHeaderSeparator() {
        return this.headerSeparator;
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public String toString() {
        return this.tableAsString;
    }
}

